/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Basic FPE-specific options.")
public class FpeOptionsBasic {
    @JsonProperty(value="radix")
    private Integer radix = null;
    @JsonProperty(value="min_length")
    private Integer minLength = null;
    @JsonProperty(value="max_length")
    private Integer maxLength = null;
    @JsonProperty(value="preserve")
    private List<Integer> preserve = null;
    @JsonProperty(value="mask")
    private List<Integer> mask = null;
    @JsonProperty(value="luhn_check")
    private Boolean luhnCheck = null;
    @JsonProperty(value="name")
    private String name = null;

    public FpeOptionsBasic radix(Integer radix) {
        this.radix = radix;
        return this;
    }

    @ApiModelProperty(required=true, value="The base for input data. The radix should be a number from 2 to 36, inclusive. Each radix corresponds to a subset of ASCII alphanumeric characters (with all letters being uppercase). For instance, a radix of 10 corresponds to a character set consisting of the digits from 0 to 9, while a character set of 16 corresponds to a character set consisting of all hexadecimal digits (with letters A-F being uppercase). ")
    @JsonProperty(value="radix")
    public Integer getRadix() {
        return this.radix;
    }

    @JsonProperty(value="radix")
    public void setRadix(Integer radix) {
        this.radix = radix;
    }

    public FpeOptionsBasic minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @ApiModelProperty(value="The minimum allowed length for the input data. If not specified, as a default, the min length will be set to the smallest value that allows the condition radix^min_length >= 100 to be satisfied.")
    @JsonProperty(value="min_length")
    public Integer getMinLength() {
        return this.minLength;
    }

    @JsonProperty(value="min_length")
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public FpeOptionsBasic maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @ApiModelProperty(value="The maximum allowed length for the input data. If not specified, a default max length of 2^16 will be used.")
    @JsonProperty(value="max_length")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @JsonProperty(value="max_length")
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public FpeOptionsBasic preserve(List<Integer> preserve) {
        this.preserve = preserve;
        return this;
    }

    public FpeOptionsBasic addPreserveItem(Integer preserveItem) {
        if (this.preserve == null) {
            this.preserve = new ArrayList<Integer>();
        }
        this.preserve.add(preserveItem);
        return this;
    }

    @ApiModelProperty(value="The list of indices of characters to be preserved while performing encryption/decryption. Indices are Python-like, where negative indices index from the back of the token, with -1 referring to the end of the token. It is an error to specify indices greater than (min_length - 1) or less than (-min_length). ")
    @JsonProperty(value="preserve")
    public List<Integer> getPreserve() {
        return this.preserve;
    }

    @JsonProperty(value="preserve")
    public void setPreserve(List<Integer> preserve) {
        this.preserve = preserve;
    }

    public FpeOptionsBasic mask(List<Integer> mask) {
        this.mask = mask;
        return this;
    }

    public FpeOptionsBasic addMaskItem(Integer maskItem) {
        if (this.mask == null) {
            this.mask = new ArrayList<Integer>();
        }
        this.mask.add(maskItem);
        return this;
    }

    @ApiModelProperty(value="The list of indices of characters to be masked while performing masked decryption. Indices are Python-like, where negative indices index from the back of the token, with -1 referring to the end of the token. It is an error to specify indices greater than (min_length - 1) or less than (-min_length). ")
    @JsonProperty(value="mask")
    public List<Integer> getMask() {
        return this.mask;
    }

    @JsonProperty(value="mask")
    public void setMask(List<Integer> mask) {
        this.mask = mask;
    }

    public FpeOptionsBasic luhnCheck(Boolean luhnCheck) {
        this.luhnCheck = luhnCheck;
        return this;
    }

    @ApiModelProperty(value="Whether encrypted/decrypted data should satisfy LUHN checksum formula.")
    @JsonProperty(value="luhn_check")
    public Boolean getLuhnCheck() {
        return this.luhnCheck;
    }

    @JsonProperty(value="luhn_check")
    public void setLuhnCheck(Boolean luhnCheck) {
        this.luhnCheck = luhnCheck;
    }

    public FpeOptionsBasic name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The user-friendly name for the data type that represents the input data.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FpeOptionsBasic fpeOptionsBasic = (FpeOptionsBasic)o;
        return Objects.equals(this.radix, fpeOptionsBasic.radix) && Objects.equals(this.minLength, fpeOptionsBasic.minLength) && Objects.equals(this.maxLength, fpeOptionsBasic.maxLength) && Objects.equals(this.preserve, fpeOptionsBasic.preserve) && Objects.equals(this.mask, fpeOptionsBasic.mask) && Objects.equals(this.luhnCheck, fpeOptionsBasic.luhnCheck) && Objects.equals(this.name, fpeOptionsBasic.name);
    }

    public int hashCode() {
        return Objects.hash(this.radix, this.minLength, this.maxLength, this.preserve, this.mask, this.luhnCheck, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FpeOptionsBasic {\n");
        sb.append("    radix: ").append(this.toIndentedString(this.radix)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    preserve: ").append(this.toIndentedString(this.preserve)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    luhnCheck: ").append(this.toIndentedString(this.luhnCheck)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

