/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.HmgConfig;
import com.fortanix.sdkms.v1.model.KeyUndoPolicy;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GroupRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="hmg")
    private Map<String, HmgConfig> hmg = null;
    @JsonProperty(value="acct_id")
    private String acctId = null;
    @JsonProperty(value="key_undo_policy")
    private KeyUndoPolicy keyUndoPolicy = null;

    public GroupRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the group. Group names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GroupRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the group.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public GroupRequest hmg(Map<String, HmgConfig> hmg) {
        this.hmg = hmg;
        return this;
    }

    public GroupRequest putHmgItem(String key, HmgConfig hmgItem) {
        if (this.hmg == null) {
            this.hmg = new HashMap<String, HmgConfig>();
        }
        this.hmg.put(key, hmgItem);
        return this;
    }

    @ApiModelProperty(value="Map from UUIDs to HmgConfig objects")
    @JsonProperty(value="hmg")
    public Map<String, HmgConfig> getHmg() {
        return this.hmg;
    }

    @JsonProperty(value="hmg")
    public void setHmg(Map<String, HmgConfig> hmg) {
        this.hmg = hmg;
    }

    public GroupRequest acctId(String acctId) {
        this.acctId = acctId;
        return this;
    }

    @ApiModelProperty(value="Account ID of the account the new group will belong to.")
    @JsonProperty(value="acct_id")
    public String getAcctId() {
        return this.acctId;
    }

    @JsonProperty(value="acct_id")
    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public GroupRequest keyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="key_undo_policy")
    public KeyUndoPolicy getKeyUndoPolicy() {
        return this.keyUndoPolicy;
    }

    @JsonProperty(value="key_undo_policy")
    public void setKeyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupRequest groupRequest = (GroupRequest)o;
        return Objects.equals(this.name, groupRequest.name) && Objects.equals(this.description, groupRequest.description) && Objects.equals(this.hmg, groupRequest.hmg) && Objects.equals(this.acctId, groupRequest.acctId) && Objects.equals(this.keyUndoPolicy, groupRequest.keyUndoPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.hmg, this.acctId, this.keyUndoPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hmg: ").append(this.toIndentedString(this.hmg)).append("\n");
        sb.append("    acctId: ").append(this.toIndentedString(this.acctId)).append("\n");
        sb.append("    keyUndoPolicy: ").append(this.toIndentedString(this.keyUndoPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

