/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class JWTSigningKeyType {
    private String value;
    public static final JWTSigningKeyType FETCHED = new JWTSigningKeyType("Fetched");
    public static final JWTSigningKeyType STORED = new JWTSigningKeyType("Stored");
    private static final Map<String, JWTSigningKeyType> valueMap = new HashMap<String, JWTSigningKeyType>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private JWTSigningKeyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JWTSigningKeyType[] values() {
        valueMapLock.lock();
        try {
            JWTSigningKeyType[] jWTSigningKeyTypeArray = valueMap.values().toArray(new JWTSigningKeyType[valueMap.values().size()]);
            return jWTSigningKeyTypeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static JWTSigningKeyType fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                JWTSigningKeyType jWTSigningKeyType = valueMap.get(val);
                return jWTSigningKeyType;
            }
            JWTSigningKeyType newValue = new JWTSigningKeyType(val);
            valueMap.put(val, newValue);
            JWTSigningKeyType jWTSigningKeyType = newValue;
            return jWTSigningKeyType;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Fetched", FETCHED);
        valueMap.put("Stored", STORED);
    }
}

