/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CreatorType;
import com.fortanix.sdkms.v1.model.EllipticCurve;
import com.fortanix.sdkms.v1.model.HistoryItem;
import com.fortanix.sdkms.v1.model.KeyObjectState;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectOrigin;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.RsaOptions;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyObject {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="key_size")
    private Integer keySize = null;
    @JsonProperty(value="elliptic_curve")
    private EllipticCurve ellipticCurve = null;
    @JsonProperty(value="acct_id")
    private String acctId = null;
    @JsonProperty(value="group_id")
    private String groupId = null;
    @JsonProperty(value="creator")
    private CreatorType creator = null;
    @JsonProperty(value="kid")
    private String kid = null;
    @JsonProperty(value="obj_type")
    private ObjectType objType = null;
    @JsonProperty(value="key_ops")
    private List<KeyOperations> keyOps = null;
    @JsonProperty(value="custom_metadata")
    private Map<String, String> customMetadata = null;
    @JsonProperty(value="origin")
    private ObjectOrigin origin = null;
    @JsonProperty(value="pub_key")
    private byte[] pubKey = null;
    @JsonProperty(value="value")
    private byte[] value = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="compliant_with_policies")
    private Boolean compliantWithPolicies = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="lastused_at")
    private String lastusedAt = null;
    @JsonProperty(value="transient_key")
    private String transientKey = null;
    @JsonProperty(value="never_exportable")
    private Boolean neverExportable = null;
    @JsonProperty(value="rsa")
    private RsaOptions rsa = null;
    @JsonProperty(value="kcv")
    private String kcv = null;
    @JsonProperty(value="state")
    private KeyObjectState state = null;
    @JsonProperty(value="history")
    private List<HistoryItem> history = null;

    public KeyObject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the security object.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public KeyObject description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the security object.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public KeyObject keySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    @ApiModelProperty(value="For objects which are not elliptic curves, this is the size in bits (not bytes) of the object. This field is not returned for elliptic curves. ")
    @JsonProperty(value="key_size")
    public Integer getKeySize() {
        return this.keySize;
    }

    @JsonProperty(value="key_size")
    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public KeyObject ellipticCurve(EllipticCurve ellipticCurve) {
        this.ellipticCurve = ellipticCurve;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="elliptic_curve")
    public EllipticCurve getEllipticCurve() {
        return this.ellipticCurve;
    }

    @JsonProperty(value="elliptic_curve")
    public void setEllipticCurve(EllipticCurve ellipticCurve) {
        this.ellipticCurve = ellipticCurve;
    }

    public KeyObject acctId(String acctId) {
        this.acctId = acctId;
        return this;
    }

    @ApiModelProperty(required=true, value="Account ID of the account this security object belongs to.")
    @JsonProperty(value="acct_id")
    public String getAcctId() {
        return this.acctId;
    }

    @JsonProperty(value="acct_id")
    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public KeyObject groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="Group ID of the security group that this security object belongs to.")
    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public KeyObject creator(CreatorType creator) {
        this.creator = creator;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="creator")
    public CreatorType getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    public void setCreator(CreatorType creator) {
        this.creator = creator;
    }

    public KeyObject kid(String kid) {
        this.kid = kid;
        return this;
    }

    @ApiModelProperty(value="Key ID uniquely identifying this security object.")
    @JsonProperty(value="kid")
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    public void setKid(String kid) {
        this.kid = kid;
    }

    public KeyObject objType(ObjectType objType) {
        this.objType = objType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="obj_type")
    public ObjectType getObjType() {
        return this.objType;
    }

    @JsonProperty(value="obj_type")
    public void setObjType(ObjectType objType) {
        this.objType = objType;
    }

    public KeyObject keyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public KeyObject addKeyOpsItem(KeyOperations keyOpsItem) {
        if (this.keyOps == null) {
            this.keyOps = new ArrayList<KeyOperations>();
        }
        this.keyOps.add(keyOpsItem);
        return this;
    }

    @ApiModelProperty(value="Array of key operations enabled for this security object. ")
    @JsonProperty(value="key_ops")
    public List<KeyOperations> getKeyOps() {
        return this.keyOps;
    }

    @JsonProperty(value="key_ops")
    public void setKeyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
    }

    public KeyObject customMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public KeyObject putCustomMetadataItem(String key, String customMetadataItem) {
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, customMetadataItem);
        return this;
    }

    @ApiModelProperty(value="User-defined metadata for this key. Stored as key-value pairs.")
    @JsonProperty(value="custom_metadata")
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public KeyObject origin(ObjectOrigin origin) {
        this.origin = origin;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="origin")
    public ObjectOrigin getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    public void setOrigin(ObjectOrigin origin) {
        this.origin = origin;
    }

    public KeyObject pubKey(byte[] pubKey) {
        this.pubKey = pubKey;
        return this;
    }

    @ApiModelProperty(value="This field is returned only for asymmetric keys. It contains the public key.")
    @JsonProperty(value="pub_key")
    public byte[] getPubKey() {
        return this.pubKey;
    }

    @JsonProperty(value="pub_key")
    public void setPubKey(byte[] pubKey) {
        this.pubKey = pubKey;
    }

    public KeyObject value(byte[] value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="This field is returned only for opaque and secret objects. It contains the contents of the object.")
    @JsonProperty(value="value")
    public byte[] getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(byte[] value) {
        this.value = value;
    }

    public KeyObject enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this security object has cryptographic operations enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public KeyObject compliantWithPolicies(Boolean compliantWithPolicies) {
        this.compliantWithPolicies = compliantWithPolicies;
        return this;
    }

    @ApiModelProperty(value="Whether this security object is compliant with cryptographic policies or not.")
    @JsonProperty(value="compliant_with_policies")
    public Boolean getCompliantWithPolicies() {
        return this.compliantWithPolicies;
    }

    @JsonProperty(value="compliant_with_policies")
    public void setCompliantWithPolicies(Boolean compliantWithPolicies) {
        this.compliantWithPolicies = compliantWithPolicies;
    }

    public KeyObject createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="When this security object was created.")
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public KeyObject lastusedAt(String lastusedAt) {
        this.lastusedAt = lastusedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="When this security object was last used.")
    @JsonProperty(value="lastused_at")
    public String getLastusedAt() {
        return this.lastusedAt;
    }

    @JsonProperty(value="lastused_at")
    public void setLastusedAt(String lastusedAt) {
        this.lastusedAt = lastusedAt;
    }

    public KeyObject transientKey(String transientKey) {
        this.transientKey = transientKey;
        return this;
    }

    @ApiModelProperty(value="Transient key blob.")
    @JsonProperty(value="transient_key")
    public String getTransientKey() {
        return this.transientKey;
    }

    @JsonProperty(value="transient_key")
    public void setTransientKey(String transientKey) {
        this.transientKey = transientKey;
    }

    public KeyObject neverExportable(Boolean neverExportable) {
        this.neverExportable = neverExportable;
        return this;
    }

    @ApiModelProperty(required=true, value="True if this key's operations have never contained EXPORT.")
    @JsonProperty(value="never_exportable")
    public Boolean getNeverExportable() {
        return this.neverExportable;
    }

    @JsonProperty(value="never_exportable")
    public void setNeverExportable(Boolean neverExportable) {
        this.neverExportable = neverExportable;
    }

    public KeyObject rsa(RsaOptions rsa) {
        this.rsa = rsa;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="rsa")
    public RsaOptions getRsa() {
        return this.rsa;
    }

    @JsonProperty(value="rsa")
    public void setRsa(RsaOptions rsa) {
        this.rsa = rsa;
    }

    public KeyObject kcv(String kcv) {
        this.kcv = kcv;
        return this;
    }

    @ApiModelProperty(value="KCV for the Security Object")
    @JsonProperty(value="kcv")
    public String getKcv() {
        return this.kcv;
    }

    @JsonProperty(value="kcv")
    public void setKcv(String kcv) {
        this.kcv = kcv;
    }

    public KeyObject state(KeyObjectState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    public KeyObjectState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(KeyObjectState state) {
        this.state = state;
    }

    public KeyObject history(List<HistoryItem> history) {
        this.history = history;
        return this;
    }

    public KeyObject addHistoryItem(HistoryItem historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<HistoryItem>();
        }
        this.history.add(historyItem);
        return this;
    }

    @ApiModelProperty(value="When a Key Undo Policy is in place, a list of (non-expired) history items is returned. Each history item represents a passed key state that can be reverted to.")
    @JsonProperty(value="history")
    public List<HistoryItem> getHistory() {
        return this.history;
    }

    @JsonProperty(value="history")
    public void setHistory(List<HistoryItem> history) {
        this.history = history;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyObject keyObject = (KeyObject)o;
        return Objects.equals(this.name, keyObject.name) && Objects.equals(this.description, keyObject.description) && Objects.equals(this.keySize, keyObject.keySize) && Objects.equals(this.ellipticCurve, keyObject.ellipticCurve) && Objects.equals(this.acctId, keyObject.acctId) && Objects.equals(this.groupId, keyObject.groupId) && Objects.equals(this.creator, keyObject.creator) && Objects.equals(this.kid, keyObject.kid) && Objects.equals(this.objType, keyObject.objType) && Objects.equals(this.keyOps, keyObject.keyOps) && Objects.equals(this.customMetadata, keyObject.customMetadata) && Objects.equals(this.origin, keyObject.origin) && Objects.equals(this.pubKey, keyObject.pubKey) && Objects.equals(this.value, keyObject.value) && Objects.equals(this.enabled, keyObject.enabled) && Objects.equals(this.compliantWithPolicies, keyObject.compliantWithPolicies) && Objects.equals(this.createdAt, keyObject.createdAt) && Objects.equals(this.lastusedAt, keyObject.lastusedAt) && Objects.equals(this.transientKey, keyObject.transientKey) && Objects.equals(this.neverExportable, keyObject.neverExportable) && Objects.equals(this.rsa, keyObject.rsa) && Objects.equals(this.kcv, keyObject.kcv) && Objects.equals(this.state, keyObject.state) && Objects.equals(this.history, keyObject.history);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.keySize, this.ellipticCurve, this.acctId, this.groupId, this.creator, this.kid, this.objType, this.keyOps, this.customMetadata, this.origin, this.pubKey, this.value, this.enabled, this.compliantWithPolicies, this.createdAt, this.lastusedAt, this.transientKey, this.neverExportable, this.rsa, this.kcv, this.state, this.history);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyObject {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keySize: ").append(this.toIndentedString(this.keySize)).append("\n");
        sb.append("    ellipticCurve: ").append(this.toIndentedString(this.ellipticCurve)).append("\n");
        sb.append("    acctId: ").append(this.toIndentedString(this.acctId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    objType: ").append(this.toIndentedString(this.objType)).append("\n");
        sb.append("    keyOps: ").append(this.toIndentedString(this.keyOps)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    pubKey: ").append(this.toIndentedString(this.pubKey)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    compliantWithPolicies: ").append(this.toIndentedString(this.compliantWithPolicies)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastusedAt: ").append(this.toIndentedString(this.lastusedAt)).append("\n");
        sb.append("    transientKey: ").append(this.toIndentedString(this.transientKey)).append("\n");
        sb.append("    neverExportable: ").append(this.toIndentedString(this.neverExportable)).append("\n");
        sb.append("    rsa: ").append(this.toIndentedString(this.rsa)).append("\n");
        sb.append("    kcv: ").append(this.toIndentedString(this.kcv)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

