/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class KeyObjectState {
    private String value;
    public static final KeyObjectState NONE = new KeyObjectState("None");
    public static final KeyObjectState PREACTIVE = new KeyObjectState("PreActive");
    public static final KeyObjectState ACTIVE = new KeyObjectState("Active");
    public static final KeyObjectState DEACTIVATED = new KeyObjectState("Deactivated");
    public static final KeyObjectState COMPROMISED = new KeyObjectState("Compromised");
    public static final KeyObjectState DESTROYED = new KeyObjectState("Destroyed");
    public static final KeyObjectState DELETED = new KeyObjectState("Deleted");
    private static final Map<String, KeyObjectState> valueMap = new HashMap<String, KeyObjectState>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private KeyObjectState(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyObjectState[] values() {
        valueMapLock.lock();
        try {
            KeyObjectState[] keyObjectStateArray = valueMap.values().toArray(new KeyObjectState[valueMap.values().size()]);
            return keyObjectStateArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static KeyObjectState fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                KeyObjectState keyObjectState = valueMap.get(val);
                return keyObjectState;
            }
            KeyObjectState newValue = new KeyObjectState(val);
            valueMap.put(val, newValue);
            KeyObjectState keyObjectState = newValue;
            return keyObjectState;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("None", NONE);
        valueMap.put("PreActive", PREACTIVE);
        valueMap.put("Active", ACTIVE);
        valueMap.put("Deactivated", DEACTIVATED);
        valueMap.put("Compromised", COMPROMISED);
        valueMap.put("Destroyed", DESTROYED);
        valueMap.put("Deleted", DELETED);
    }
}

