/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class NotificationPref {
    private String value;
    public static final NotificationPref NONE = new NotificationPref("None");
    public static final NotificationPref EMAIL = new NotificationPref("Email");
    public static final NotificationPref PHONE = new NotificationPref("Phone");
    public static final NotificationPref BOTH = new NotificationPref("Both");
    private static final Map<String, NotificationPref> valueMap = new HashMap<String, NotificationPref>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private NotificationPref(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationPref[] values() {
        valueMapLock.lock();
        try {
            NotificationPref[] notificationPrefArray = valueMap.values().toArray(new NotificationPref[valueMap.values().size()]);
            return notificationPrefArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static NotificationPref fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                NotificationPref notificationPref = valueMap.get(val);
                return notificationPref;
            }
            NotificationPref newValue = new NotificationPref(val);
            valueMap.put(val, newValue);
            NotificationPref notificationPref = newValue;
            return notificationPref;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("None", NONE);
        valueMap.put("Email", EMAIL);
        valueMap.put("Phone", PHONE);
        valueMap.put("Both", BOTH);
    }
}

