/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CreatorType;
import com.fortanix.sdkms.v1.model.PluginSource;
import com.fortanix.sdkms.v1.model.PluginType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Plugin {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="plugin_id")
    private String pluginId = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="acct_id")
    private String acctId = null;
    @JsonProperty(value="groups")
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="default_group")
    private String defaultGroup = null;
    @JsonProperty(value="source")
    private PluginSource source = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="plugin_type")
    private PluginType pluginType = null;
    @JsonProperty(value="creator")
    private CreatorType creator = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="lastrun_at")
    private String lastrunAt = null;
    @JsonProperty(value="lastupdated_at")
    private String lastupdatedAt = null;

    public Plugin name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the plugin. Plugin names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Plugin pluginId(String pluginId) {
        this.pluginId = pluginId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plugin ID uniquely identifying this plugin.")
    @JsonProperty(value="plugin_id")
    public String getPluginId() {
        return this.pluginId;
    }

    @JsonProperty(value="plugin_id")
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public Plugin description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of this plugin.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Plugin acctId(String acctId) {
        this.acctId = acctId;
        return this;
    }

    @ApiModelProperty(required=true, value="The account ID of the account that this plugin belongs to.")
    @JsonProperty(value="acct_id")
    public String getAcctId() {
        return this.acctId;
    }

    @JsonProperty(value="acct_id")
    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public Plugin groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public Plugin addGroupsItem(String groupsItem) {
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of security group IDs. The plugin belongs to each Security Group in this array.")
    @JsonProperty(value="groups")
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public Plugin defaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
        return this;
    }

    @ApiModelProperty(required=true, value="The default group of this plugin. This is the group where security objects will be created by default by this plugin.")
    @JsonProperty(value="default_group")
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @JsonProperty(value="default_group")
    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public Plugin source(PluginSource source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="source")
    public PluginSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(PluginSource source) {
        this.source = source;
    }

    public Plugin enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this plugin is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Plugin pluginType(PluginType pluginType) {
        this.pluginType = pluginType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="plugin_type")
    public PluginType getPluginType() {
        return this.pluginType;
    }

    @JsonProperty(value="plugin_type")
    public void setPluginType(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    public Plugin creator(CreatorType creator) {
        this.creator = creator;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="creator")
    public CreatorType getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    public void setCreator(CreatorType creator) {
        this.creator = creator;
    }

    public Plugin createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="When this plugin was created.")
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Plugin lastrunAt(String lastrunAt) {
        this.lastrunAt = lastrunAt;
        return this;
    }

    @ApiModelProperty(required=true, value="When this plugin was last run.")
    @JsonProperty(value="lastrun_at")
    public String getLastrunAt() {
        return this.lastrunAt;
    }

    @JsonProperty(value="lastrun_at")
    public void setLastrunAt(String lastrunAt) {
        this.lastrunAt = lastrunAt;
    }

    public Plugin lastupdatedAt(String lastupdatedAt) {
        this.lastupdatedAt = lastupdatedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="When this plugin was last updated.")
    @JsonProperty(value="lastupdated_at")
    public String getLastupdatedAt() {
        return this.lastupdatedAt;
    }

    @JsonProperty(value="lastupdated_at")
    public void setLastupdatedAt(String lastupdatedAt) {
        this.lastupdatedAt = lastupdatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.name, plugin.name) && Objects.equals(this.pluginId, plugin.pluginId) && Objects.equals(this.description, plugin.description) && Objects.equals(this.acctId, plugin.acctId) && Objects.equals(this.groups, plugin.groups) && Objects.equals(this.defaultGroup, plugin.defaultGroup) && Objects.equals(this.source, plugin.source) && Objects.equals(this.enabled, plugin.enabled) && Objects.equals(this.pluginType, plugin.pluginType) && Objects.equals(this.creator, plugin.creator) && Objects.equals(this.createdAt, plugin.createdAt) && Objects.equals(this.lastrunAt, plugin.lastrunAt) && Objects.equals(this.lastupdatedAt, plugin.lastupdatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pluginId, this.description, this.acctId, this.groups, this.defaultGroup, this.source, this.enabled, this.pluginType, this.creator, this.createdAt, this.lastrunAt, this.lastupdatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Plugin {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pluginId: ").append(this.toIndentedString(this.pluginId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    acctId: ").append(this.toIndentedString(this.acctId)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    defaultGroup: ").append(this.toIndentedString(this.defaultGroup)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    pluginType: ").append(this.toIndentedString(this.pluginType)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastrunAt: ").append(this.toIndentedString(this.lastrunAt)).append("\n");
        sb.append("    lastupdatedAt: ").append(this.toIndentedString(this.lastupdatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

