/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.DsaOptions;
import com.fortanix.sdkms.v1.model.EllipticCurve;
import com.fortanix.sdkms.v1.model.FpeOptions;
import com.fortanix.sdkms.v1.model.KeyObjectState;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.RsaOptions;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SobjectRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="key_size")
    private Integer keySize = null;
    @JsonProperty(value="pub_exponent")
    private Integer pubExponent = null;
    @JsonProperty(value="elliptic_curve")
    private EllipticCurve ellipticCurve = null;
    @JsonProperty(value="rsa")
    private RsaOptions rsa = null;
    @JsonProperty(value="dsa")
    private DsaOptions dsa = null;
    @JsonProperty(value="fpe")
    private FpeOptions fpe = null;
    @JsonProperty(value="group_id")
    private String groupId = null;
    @JsonProperty(value="obj_type")
    private ObjectType objType = null;
    @JsonProperty(value="key_ops")
    private List<KeyOperations> keyOps = null;
    @JsonProperty(value="custom_metadata")
    private Map<String, String> customMetadata = null;
    @JsonProperty(value="value")
    private byte[] value = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="transient")
    private Boolean _transient = null;
    @JsonProperty(value="deterministic_signatures")
    private Boolean deterministicSignatures = null;
    @JsonProperty(value="state")
    private KeyObjectState state = null;
    @JsonProperty(value="deactivation_date")
    private String deactivationDate = null;

    public SobjectRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the security object to create or import. Security object names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public SobjectRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the security object to create or import.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public SobjectRequest keySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    @ApiModelProperty(value="Size in bits (not bytes) of the security object to create or import. Required for symmetric keys. For DSA keys, it represents the size of `p`; allowed values are 2048 or 3072. Deprecated for RSA keys, specify it in `RsaOptions` instead.")
    @JsonProperty(value="key_size")
    public Integer getKeySize() {
        return this.keySize;
    }

    @JsonProperty(value="key_size")
    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public SobjectRequest pubExponent(Integer pubExponent) {
        this.pubExponent = pubExponent;
        return this;
    }

    @ApiModelProperty(value="For RSA keys only. Deprecated. Specify in `RsaOptions` instead. Public exponent to use when generating an RSA key.")
    @JsonProperty(value="pub_exponent")
    public Integer getPubExponent() {
        return this.pubExponent;
    }

    @JsonProperty(value="pub_exponent")
    public void setPubExponent(Integer pubExponent) {
        this.pubExponent = pubExponent;
    }

    public SobjectRequest ellipticCurve(EllipticCurve ellipticCurve) {
        this.ellipticCurve = ellipticCurve;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="elliptic_curve")
    public EllipticCurve getEllipticCurve() {
        return this.ellipticCurve;
    }

    @JsonProperty(value="elliptic_curve")
    public void setEllipticCurve(EllipticCurve ellipticCurve) {
        this.ellipticCurve = ellipticCurve;
    }

    public SobjectRequest rsa(RsaOptions rsa) {
        this.rsa = rsa;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="rsa")
    public RsaOptions getRsa() {
        return this.rsa;
    }

    @JsonProperty(value="rsa")
    public void setRsa(RsaOptions rsa) {
        this.rsa = rsa;
    }

    public SobjectRequest dsa(DsaOptions dsa) {
        this.dsa = dsa;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dsa")
    public DsaOptions getDsa() {
        return this.dsa;
    }

    @JsonProperty(value="dsa")
    public void setDsa(DsaOptions dsa) {
        this.dsa = dsa;
    }

    public SobjectRequest fpe(FpeOptions fpe) {
        this.fpe = fpe;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fpe")
    public FpeOptions getFpe() {
        return this.fpe;
    }

    @JsonProperty(value="fpe")
    public void setFpe(FpeOptions fpe) {
        this.fpe = fpe;
    }

    public SobjectRequest groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="Group ID (not name) of the security group that this security object should belong to. The user or application creating this security object must be a member of this group. If no group is specified, the default group for the user or application will be used. ")
    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public SobjectRequest objType(ObjectType objType) {
        this.objType = objType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="obj_type")
    public ObjectType getObjType() {
        return this.objType;
    }

    @JsonProperty(value="obj_type")
    public void setObjType(ObjectType objType) {
        this.objType = objType;
    }

    public SobjectRequest keyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public SobjectRequest addKeyOpsItem(KeyOperations keyOpsItem) {
        if (this.keyOps == null) {
            this.keyOps = new ArrayList<KeyOperations>();
        }
        this.keyOps.add(keyOpsItem);
        return this;
    }

    @ApiModelProperty(value="Optional array of key operations to be enabled for this security object. If this property is not provided, the SDKMS server will provide a default set of key operations. Note that if you provide an empty array, all key operations will be disabled. ")
    @JsonProperty(value="key_ops")
    public List<KeyOperations> getKeyOps() {
        return this.keyOps;
    }

    @JsonProperty(value="key_ops")
    public void setKeyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
    }

    public SobjectRequest customMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public SobjectRequest putCustomMetadataItem(String key, String customMetadataItem) {
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, customMetadataItem);
        return this;
    }

    @ApiModelProperty(value="User-defined metadata for this key. Stored as key-value pairs.")
    @JsonProperty(value="custom_metadata")
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public SobjectRequest value(byte[] value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="When importing a security object, this field contains the binary contents to import. When creating a security object, this field is unused. The value of an OPAQUE or CERTIFICATE object is always returned. For other objects, the value is returned only with `/crypto/v1/keys/export` API (if the object is exportable). ")
    @JsonProperty(value="value")
    public byte[] getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(byte[] value) {
        this.value = value;
    }

    public SobjectRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether the new security object should be enabled. Disabled security objects may not perform cryptographic operations. ")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SobjectRequest _transient(Boolean _transient) {
        this._transient = _transient;
        return this;
    }

    @ApiModelProperty(value="If this is true, SDKMS will create a transient key.")
    @JsonProperty(value="transient")
    public Boolean getTransient() {
        return this._transient;
    }

    @JsonProperty(value="transient")
    public void setTransient(Boolean _transient) {
        this._transient = _transient;
    }

    public SobjectRequest deterministicSignatures(Boolean deterministicSignatures) {
        this.deterministicSignatures = deterministicSignatures;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="deterministic_signatures")
    public Boolean getDeterministicSignatures() {
        return this.deterministicSignatures;
    }

    @JsonProperty(value="deterministic_signatures")
    public void setDeterministicSignatures(Boolean deterministicSignatures) {
        this.deterministicSignatures = deterministicSignatures;
    }

    public SobjectRequest state(KeyObjectState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    public KeyObjectState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(KeyObjectState state) {
        this.state = state;
    }

    public SobjectRequest deactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
        return this;
    }

    @ApiModelProperty(value="When this object will be deactivated.")
    @JsonProperty(value="deactivation_date")
    public String getDeactivationDate() {
        return this.deactivationDate;
    }

    @JsonProperty(value="deactivation_date")
    public void setDeactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SobjectRequest sobjectRequest = (SobjectRequest)o;
        return Objects.equals(this.name, sobjectRequest.name) && Objects.equals(this.description, sobjectRequest.description) && Objects.equals(this.keySize, sobjectRequest.keySize) && Objects.equals(this.pubExponent, sobjectRequest.pubExponent) && Objects.equals(this.ellipticCurve, sobjectRequest.ellipticCurve) && Objects.equals(this.rsa, sobjectRequest.rsa) && Objects.equals(this.dsa, sobjectRequest.dsa) && Objects.equals(this.fpe, sobjectRequest.fpe) && Objects.equals(this.groupId, sobjectRequest.groupId) && Objects.equals(this.objType, sobjectRequest.objType) && Objects.equals(this.keyOps, sobjectRequest.keyOps) && Objects.equals(this.customMetadata, sobjectRequest.customMetadata) && Objects.equals(this.value, sobjectRequest.value) && Objects.equals(this.enabled, sobjectRequest.enabled) && Objects.equals(this._transient, sobjectRequest._transient) && Objects.equals(this.deterministicSignatures, sobjectRequest.deterministicSignatures) && Objects.equals(this.state, sobjectRequest.state) && Objects.equals(this.deactivationDate, sobjectRequest.deactivationDate);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.keySize, this.pubExponent, this.ellipticCurve, this.rsa, this.dsa, this.fpe, this.groupId, this.objType, this.keyOps, this.customMetadata, this.value, this.enabled, this._transient, this.deterministicSignatures, this.state, this.deactivationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SobjectRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keySize: ").append(this.toIndentedString(this.keySize)).append("\n");
        sb.append("    pubExponent: ").append(this.toIndentedString(this.pubExponent)).append("\n");
        sb.append("    ellipticCurve: ").append(this.toIndentedString(this.ellipticCurve)).append("\n");
        sb.append("    rsa: ").append(this.toIndentedString(this.rsa)).append("\n");
        sb.append("    dsa: ").append(this.toIndentedString(this.dsa)).append("\n");
        sb.append("    fpe: ").append(this.toIndentedString(this.fpe)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    objType: ").append(this.toIndentedString(this.objType)).append("\n");
        sb.append("    keyOps: ").append(this.toIndentedString(this.keyOps)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    _transient: ").append(this.toIndentedString(this._transient)).append("\n");
        sb.append("    deterministicSignatures: ").append(this.toIndentedString(this.deterministicSignatures)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    deactivationDate: ").append(this.toIndentedString(this.deactivationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

