/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.RsaOptions;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UnwrapKeyRequestEx {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="alg")
    private ObjectType alg = null;
    @JsonProperty(value="group_id")
    private String groupId = null;
    @JsonProperty(value="obj_type")
    private ObjectType objType = null;
    @JsonProperty(value="wrapped_key")
    private byte[] wrappedKey = null;
    @JsonProperty(value="mode")
    private CryptMode mode = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;
    @JsonProperty(value="tag")
    private byte[] tag = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="key_ops")
    private List<KeyOperations> keyOps = null;
    @JsonProperty(value="custom_metadata")
    private Map<String, String> customMetadata = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="rsa")
    private RsaOptions rsa = null;

    public UnwrapKeyRequestEx key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public UnwrapKeyRequestEx alg(ObjectType alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="alg")
    public ObjectType getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    public void setAlg(ObjectType alg) {
        this.alg = alg;
    }

    public UnwrapKeyRequestEx groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="Group ID (not name) of the security group that this security object should belong to. The user or application creating this security object must be a member of this group. If no group is specified, the default group for the user or application will be used. ")
    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public UnwrapKeyRequestEx objType(ObjectType objType) {
        this.objType = objType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="obj_type")
    public ObjectType getObjType() {
        return this.objType;
    }

    @JsonProperty(value="obj_type")
    public void setObjType(ObjectType objType) {
        this.objType = objType;
    }

    public UnwrapKeyRequestEx wrappedKey(byte[] wrappedKey) {
        this.wrappedKey = wrappedKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A Security Object previously wrapped with another key. ")
    @JsonProperty(value="wrapped_key")
    public byte[] getWrappedKey() {
        return this.wrappedKey;
    }

    @JsonProperty(value="wrapped_key")
    public void setWrappedKey(byte[] wrappedKey) {
        this.wrappedKey = wrappedKey;
    }

    public UnwrapKeyRequestEx mode(CryptMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public CryptMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CryptMode mode) {
        this.mode = mode;
    }

    public UnwrapKeyRequestEx iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="The initialization value used to encrypt this ciphertext. This field is required for symmetric ciphers, and ignored for asymmetric ciphers. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public UnwrapKeyRequestEx ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="The authenticated data used with this ciphertext and authentication tag. This field is required for symmetric ciphers using cipher mode GCM or CCM, and must not be specified for all other ciphers. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public UnwrapKeyRequestEx tag(byte[] tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(value="The authentication tag used with this ciphertext and authenticated data. This field is required for symmetric ciphers using cipher mode GCM or CCM, and must not be specified for all other ciphers. ")
    @JsonProperty(value="tag")
    public byte[] getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    public void setTag(byte[] tag) {
        this.tag = tag;
    }

    public UnwrapKeyRequestEx name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the security object to unwrap. Security object names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public UnwrapKeyRequestEx description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the Security object to unwrap.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public UnwrapKeyRequestEx keyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public UnwrapKeyRequestEx addKeyOpsItem(KeyOperations keyOpsItem) {
        if (this.keyOps == null) {
            this.keyOps = new ArrayList<KeyOperations>();
        }
        this.keyOps.add(keyOpsItem);
        return this;
    }

    @ApiModelProperty(value="Optional array of key operations to be enabled for this security object. If this property is not provided, the SDKMS server will provide a default set of key operations. Note that if you provide an empty array, all key operations will be disabled. ")
    @JsonProperty(value="key_ops")
    public List<KeyOperations> getKeyOps() {
        return this.keyOps;
    }

    @JsonProperty(value="key_ops")
    public void setKeyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
    }

    public UnwrapKeyRequestEx customMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public UnwrapKeyRequestEx putCustomMetadataItem(String key, String customMetadataItem) {
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, customMetadataItem);
        return this;
    }

    @ApiModelProperty(value="User-defined metadata for this key. Stored as key-value pairs.")
    @JsonProperty(value="custom_metadata")
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public UnwrapKeyRequestEx enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether the new security object should be enabled. Disabled security objects may not perform cryptographic operations. ")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UnwrapKeyRequestEx rsa(RsaOptions rsa) {
        this.rsa = rsa;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="rsa")
    public RsaOptions getRsa() {
        return this.rsa;
    }

    @JsonProperty(value="rsa")
    public void setRsa(RsaOptions rsa) {
        this.rsa = rsa;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnwrapKeyRequestEx unwrapKeyRequestEx = (UnwrapKeyRequestEx)o;
        return Objects.equals(this.key, unwrapKeyRequestEx.key) && Objects.equals(this.alg, unwrapKeyRequestEx.alg) && Objects.equals(this.groupId, unwrapKeyRequestEx.groupId) && Objects.equals(this.objType, unwrapKeyRequestEx.objType) && Objects.equals(this.wrappedKey, unwrapKeyRequestEx.wrappedKey) && Objects.equals(this.mode, unwrapKeyRequestEx.mode) && Objects.equals(this.iv, unwrapKeyRequestEx.iv) && Objects.equals(this.ad, unwrapKeyRequestEx.ad) && Objects.equals(this.tag, unwrapKeyRequestEx.tag) && Objects.equals(this.name, unwrapKeyRequestEx.name) && Objects.equals(this.description, unwrapKeyRequestEx.description) && Objects.equals(this.keyOps, unwrapKeyRequestEx.keyOps) && Objects.equals(this.customMetadata, unwrapKeyRequestEx.customMetadata) && Objects.equals(this.enabled, unwrapKeyRequestEx.enabled) && Objects.equals(this.rsa, unwrapKeyRequestEx.rsa);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.alg, this.groupId, this.objType, this.wrappedKey, this.mode, this.iv, this.ad, this.tag, this.name, this.description, this.keyOps, this.customMetadata, this.enabled, this.rsa);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnwrapKeyRequestEx {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    objType: ").append(this.toIndentedString(this.objType)).append("\n");
        sb.append("    wrappedKey: ").append(this.toIndentedString(this.wrappedKey)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keyOps: ").append(this.toIndentedString(this.keyOps)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    rsa: ").append(this.toIndentedString(this.rsa)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

