/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.U2fDevice;
import com.fortanix.sdkms.v1.model.UserAccountFlags;
import com.fortanix.sdkms.v1.model.UserGroupMap;
import com.fortanix.sdkms.v1.model.UserState;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class User {
    @JsonProperty(value="user_id")
    private String userId = null;
    @JsonProperty(value="user_email")
    private String userEmail = null;
    @JsonProperty(value="state")
    private UserState state = null;
    @JsonProperty(value="account_role")
    private List<UserAccountFlags> accountRole = null;
    @JsonProperty(value="groups")
    private UserGroupMap groups = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="email_verified")
    private Boolean emailVerified = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="last_logged_in_at")
    private String lastLoggedInAt = null;
    @JsonProperty(value="u2f_devices")
    private List<U2fDevice> u2fDevices = new ArrayList<U2fDevice>();

    public User userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="User ID uniquely identifying this user.")
    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public User userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @ApiModelProperty(required=true, value="The User's email address.")
    @JsonProperty(value="user_email")
    public String getUserEmail() {
        return this.userEmail;
    }

    @JsonProperty(value="user_email")
    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public User state(UserState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="state")
    public UserState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(UserState state) {
        this.state = state;
    }

    public User accountRole(List<UserAccountFlags> accountRole) {
        this.accountRole = accountRole;
        return this;
    }

    public User addAccountRoleItem(UserAccountFlags accountRoleItem) {
        if (this.accountRole == null) {
            this.accountRole = new ArrayList<UserAccountFlags>();
        }
        this.accountRole.add(accountRoleItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="account_role")
    public List<UserAccountFlags> getAccountRole() {
        return this.accountRole;
    }

    @JsonProperty(value="account_role")
    public void setAccountRole(List<UserAccountFlags> accountRole) {
        this.accountRole = accountRole;
    }

    public User groups(UserGroupMap groups) {
        this.groups = groups;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="groups")
    public UserGroupMap getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    public void setGroups(UserGroupMap groups) {
        this.groups = groups;
    }

    public User enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this user's account is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public User emailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this user's email has been verified.")
    @JsonProperty(value="email_verified")
    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    @JsonProperty(value="email_verified")
    public void setEmailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public User createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="When this user was added to SDKMS.")
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public User lastLoggedInAt(String lastLoggedInAt) {
        this.lastLoggedInAt = lastLoggedInAt;
        return this;
    }

    @ApiModelProperty(value="When this user last logged in.")
    @JsonProperty(value="last_logged_in_at")
    public String getLastLoggedInAt() {
        return this.lastLoggedInAt;
    }

    @JsonProperty(value="last_logged_in_at")
    public void setLastLoggedInAt(String lastLoggedInAt) {
        this.lastLoggedInAt = lastLoggedInAt;
    }

    public User u2fDevices(List<U2fDevice> u2fDevices) {
        this.u2fDevices = u2fDevices;
        return this;
    }

    public User addU2fDevicesItem(U2fDevice u2fDevicesItem) {
        this.u2fDevices.add(u2fDevicesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="u2f_devices")
    public List<U2fDevice> getU2fDevices() {
        return this.u2fDevices;
    }

    @JsonProperty(value="u2f_devices")
    public void setU2fDevices(List<U2fDevice> u2fDevices) {
        this.u2fDevices = u2fDevices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.userId, user.userId) && Objects.equals(this.userEmail, user.userEmail) && Objects.equals(this.state, user.state) && Objects.equals(this.accountRole, user.accountRole) && Objects.equals(this.groups, user.groups) && Objects.equals(this.enabled, user.enabled) && Objects.equals(this.emailVerified, user.emailVerified) && Objects.equals(this.createdAt, user.createdAt) && Objects.equals(this.lastLoggedInAt, user.lastLoggedInAt) && Objects.equals(this.u2fDevices, user.u2fDevices);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.userEmail, this.state, this.accountRole, this.groups, this.enabled, this.emailVerified, this.createdAt, this.lastLoggedInAt, this.u2fDevices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    accountRole: ").append(this.toIndentedString(this.accountRole)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    emailVerified: ").append(this.toIndentedString(this.emailVerified)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastLoggedInAt: ").append(this.toIndentedString(this.lastLoggedInAt)).append("\n");
        sb.append("    u2fDevices: ").append(this.toIndentedString(this.u2fDevices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

