/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class UserAccountFlags {
    private String value;
    public static final UserAccountFlags ACCOUNTADMINISTRATOR = new UserAccountFlags("AccountAdministrator");
    public static final UserAccountFlags ACCOUNTMEMBER = new UserAccountFlags("AccountMember");
    public static final UserAccountFlags ACCOUNTAUDITOR = new UserAccountFlags("AccountAuditor");
    public static final UserAccountFlags STATEENABLED = new UserAccountFlags("StateEnabled");
    public static final UserAccountFlags PENDINGINVITE = new UserAccountFlags("PendingInvite");
    private static final Map<String, UserAccountFlags> valueMap = new HashMap<String, UserAccountFlags>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private UserAccountFlags(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserAccountFlags[] values() {
        valueMapLock.lock();
        try {
            UserAccountFlags[] userAccountFlagsArray = valueMap.values().toArray(new UserAccountFlags[valueMap.values().size()]);
            return userAccountFlagsArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static UserAccountFlags fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                UserAccountFlags userAccountFlags = valueMap.get(val);
                return userAccountFlags;
            }
            UserAccountFlags newValue = new UserAccountFlags(val);
            valueMap.put(val, newValue);
            UserAccountFlags userAccountFlags = newValue;
            return userAccountFlags;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("AccountAdministrator", ACCOUNTADMINISTRATOR);
        valueMap.put("AccountMember", ACCOUNTMEMBER);
        valueMap.put("AccountAuditor", ACCOUNTAUDITOR);
        valueMap.put("StateEnabled", STATEENABLED);
        valueMap.put("PendingInvite", PENDINGINVITE);
    }
}

