/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class UserState {
    private String value;
    public static final UserState PENDINGCONFIRMATION = new UserState("PendingConfirmation");
    public static final UserState LOCKED = new UserState("Locked");
    public static final UserState DISABLED = new UserState("Disabled");
    public static final UserState ACTIVE = new UserState("Active");
    private static final Map<String, UserState> valueMap = new HashMap<String, UserState>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private UserState(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserState[] values() {
        valueMapLock.lock();
        try {
            UserState[] userStateArray = valueMap.values().toArray(new UserState[valueMap.values().size()]);
            return userStateArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static UserState fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                UserState userState = valueMap.get(val);
                return userState;
            }
            UserState newValue = new UserState(val);
            valueMap.put(val, newValue);
            UserState userState = newValue;
            return userState;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("PendingConfirmation", PENDINGCONFIRMATION);
        valueMap.put("Locked", LOCKED);
        valueMap.put("Disabled", DISABLED);
        valueMap.put("Active", ACTIVE);
    }
}

