/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.ServerMode;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class VersionResponse {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="api_version")
    private String apiVersion = null;
    @JsonProperty(value="server_mode")
    private ServerMode serverMode = null;
    @JsonProperty(value="fips_level")
    private Integer fipsLevel = null;

    public VersionResponse version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="The SDKMS server version. This is encoded as major.minor.build. For example, 1.0.25. ")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public VersionResponse apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="The API version implemented by this server.")
    @JsonProperty(value="api_version")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="api_version")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public VersionResponse serverMode(ServerMode serverMode) {
        this.serverMode = serverMode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="server_mode")
    public ServerMode getServerMode() {
        return this.serverMode;
    }

    @JsonProperty(value="server_mode")
    public void setServerMode(ServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public VersionResponse fipsLevel(Integer fipsLevel) {
        this.fipsLevel = fipsLevel;
        return this;
    }

    @ApiModelProperty(value="FIPS level at which SDKMS in running. If this field is absent, then SDKMS is not running in FIPS compliant mode.")
    @JsonProperty(value="fips_level")
    public Integer getFipsLevel() {
        return this.fipsLevel;
    }

    @JsonProperty(value="fips_level")
    public void setFipsLevel(Integer fipsLevel) {
        this.fipsLevel = fipsLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionResponse versionResponse = (VersionResponse)o;
        return Objects.equals(this.version, versionResponse.version) && Objects.equals(this.apiVersion, versionResponse.apiVersion) && Objects.equals(this.serverMode, versionResponse.serverMode) && Objects.equals(this.fipsLevel, versionResponse.fipsLevel);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.apiVersion, this.serverMode, this.fipsLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionResponse {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    serverMode: ").append(this.toIndentedString(this.serverMode)).append("\n");
        sb.append("    fipsLevel: ").append(this.toIndentedString(this.fipsLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

