/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.api;

import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.Configuration;
import com.fortanix.sdkms.v1.Pair;
import com.fortanix.sdkms.v1.model.BatchMacRequest;
import com.fortanix.sdkms.v1.model.BatchMacResponse;
import com.fortanix.sdkms.v1.model.BatchMacVerifyRequest;
import com.fortanix.sdkms.v1.model.BatchVerifyResponse;
import com.fortanix.sdkms.v1.model.DigestRequest;
import com.fortanix.sdkms.v1.model.DigestResponse;
import com.fortanix.sdkms.v1.model.MacGenerateRequest;
import com.fortanix.sdkms.v1.model.MacGenerateRequestEx;
import com.fortanix.sdkms.v1.model.MacGenerateResponse;
import com.fortanix.sdkms.v1.model.MacVerifyRequest;
import com.fortanix.sdkms.v1.model.MacVerifyRequestEx;
import com.fortanix.sdkms.v1.model.MacVerifyResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DigestApi {
    private ApiClient apiClient;

    public DigestApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DigestApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BatchMacResponse batchMac(BatchMacRequest body) throws ApiException {
        BatchMacRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchMac");
        }
        String localVarPath = "/crypto/v1/keys/batch/mac";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<BatchMacResponse> localVarReturnType = new GenericType<BatchMacResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchVerifyResponse batchMacVerify(BatchMacVerifyRequest body) throws ApiException {
        BatchMacVerifyRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchMacVerify");
        }
        String localVarPath = "/crypto/v1/keys/batch/macverify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<BatchVerifyResponse> localVarReturnType = new GenericType<BatchVerifyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DigestResponse computeDigest(DigestRequest body) throws ApiException {
        DigestRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling computeDigest");
        }
        String localVarPath = "/crypto/v1/digest";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<DigestResponse> localVarReturnType = new GenericType<DigestResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MacGenerateResponse computeMac(String keyId, MacGenerateRequest body) throws ApiException {
        MacGenerateRequest localVarPostBody = body;
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling computeMac");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling computeMac");
        }
        String localVarPath = "/crypto/v1/keys/{key-id}/mac".replaceAll("\\{key-id\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<MacGenerateResponse> localVarReturnType = new GenericType<MacGenerateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MacGenerateResponse computeMacEx(MacGenerateRequestEx body) throws ApiException {
        MacGenerateRequestEx localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling computeMacEx");
        }
        String localVarPath = "/crypto/v1/mac";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<MacGenerateResponse> localVarReturnType = new GenericType<MacGenerateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MacVerifyResponse verifyMac(String keyId, MacVerifyRequest body) throws ApiException {
        MacVerifyRequest localVarPostBody = body;
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling verifyMac");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling verifyMac");
        }
        String localVarPath = "/crypto/v1/keys/{key-id}/macverify".replaceAll("\\{key-id\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<MacVerifyResponse> localVarReturnType = new GenericType<MacVerifyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MacVerifyResponse verifyMacEx(MacVerifyRequestEx body) throws ApiException {
        MacVerifyRequestEx localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling verifyMacEx");
        }
        String localVarPath = "/crypto/v1/macverify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<MacVerifyResponse> localVarReturnType = new GenericType<MacVerifyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

