/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class AccountState {
    private String value;
    public static final AccountState PENDINGCONFIRMATION = new AccountState("PendingConfirmation");
    public static final AccountState ACTIVATED = new AccountState("Activated");
    public static final AccountState DISABLED = new AccountState("Disabled");
    private static final Map<String, AccountState> valueMap = new HashMap<String, AccountState>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private AccountState(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountState[] values() {
        valueMapLock.lock();
        try {
            AccountState[] accountStateArray = valueMap.values().toArray(new AccountState[valueMap.values().size()]);
            return accountStateArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static AccountState fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                AccountState accountState = valueMap.get(val);
                return accountState;
            }
            AccountState newValue = new AccountState(val);
            valueMap.put(val, newValue);
            AccountState accountState = newValue;
            return accountState;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("PendingConfirmation", PENDINGCONFIRMATION);
        valueMap.put("Activated", ACTIVATED);
        valueMap.put("Disabled", DISABLED);
    }
}

