/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class AppAuthType {
    private String value;
    public static final AppAuthType SECRET = new AppAuthType("Secret");
    public static final AppAuthType CERTIFICATE = new AppAuthType("Certificate");
    public static final AppAuthType TRUSTEDCA = new AppAuthType("TrustedCa");
    public static final AppAuthType GOOGLESERVICEACCOUNT = new AppAuthType("GoogleServiceAccount");
    public static final AppAuthType SIGNEDJWT = new AppAuthType("SignedJwt");
    private static final Map<String, AppAuthType> valueMap = new HashMap<String, AppAuthType>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private AppAuthType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppAuthType[] values() {
        valueMapLock.lock();
        try {
            AppAuthType[] appAuthTypeArray = valueMap.values().toArray(new AppAuthType[valueMap.values().size()]);
            return appAuthTypeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static AppAuthType fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                AppAuthType appAuthType = valueMap.get(val);
                return appAuthType;
            }
            AppAuthType newValue = new AppAuthType(val);
            valueMap.put(val, newValue);
            AppAuthType appAuthType = newValue;
            return appAuthType;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Secret", SECRET);
        valueMap.put("Certificate", CERTIFICATE);
        valueMap.put("TrustedCa", TRUSTEDCA);
        valueMap.put("GoogleServiceAccount", GOOGLESERVICEACCOUNT);
        valueMap.put("SignedJwt", SIGNEDJWT);
    }
}

