/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Oauth configuration for this application.")
public class AppOauthConfig {
    @JsonProperty(value="redirect_uris")
    private List<String> redirectUris = null;
    @JsonProperty(value="disabled")
    private Boolean disabled = null;

    public AppOauthConfig redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public AppOauthConfig addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="redirect_uris")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirect_uris")
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public AppOauthConfig disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(value="Whether oauth for this app is disabled")
    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppOauthConfig appOauthConfig = (AppOauthConfig)o;
        return Objects.equals(this.redirectUris, appOauthConfig.redirectUris) && Objects.equals(this.disabled, appOauthConfig.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.redirectUris, this.disabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppOauthConfig {\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

