/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.AppCredential;
import com.fortanix.sdkms.v1.model.AppOauthConfig;
import com.fortanix.sdkms.v1.model.AppPermissions;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AppRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="add_groups")
    private Map<String, List<AppPermissions>> addGroups = new HashMap<String, List<AppPermissions>>();
    @JsonProperty(value="del_groups")
    private List<String> delGroups = null;
    @JsonProperty(value="mod_groups")
    private Map<String, List<AppPermissions>> modGroups = null;
    @JsonProperty(value="default_group")
    private String defaultGroup = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="AppOauthConfig")
    private AppOauthConfig appOauthConfig = null;
    @JsonProperty(value="interface")
    private String _interface = null;
    @JsonProperty(value="app_type")
    private String appType = null;
    @JsonProperty(value="credential")
    private AppCredential credential = null;
    @JsonProperty(value="secret_size")
    private Integer secretSize = null;

    public AppRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of this application. Application names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public AppRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of this application.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public AppRequest addGroups(Map<String, List<AppPermissions>> addGroups) {
        this.addGroups = addGroups;
        return this;
    }

    public AppRequest putAddGroupsItem(String key, List<AppPermissions> addGroupsItem) {
        this.addGroups.put(key, addGroupsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Map from UUIDs to group permissions")
    @JsonProperty(value="add_groups")
    public Map<String, List<AppPermissions>> getAddGroups() {
        return this.addGroups;
    }

    @JsonProperty(value="add_groups")
    public void setAddGroups(Map<String, List<AppPermissions>> addGroups) {
        this.addGroups = addGroups;
    }

    public AppRequest delGroups(List<String> delGroups) {
        this.delGroups = delGroups;
        return this;
    }

    public AppRequest addDelGroupsItem(String delGroupsItem) {
        if (this.delGroups == null) {
            this.delGroups = new ArrayList<String>();
        }
        this.delGroups.add(delGroupsItem);
        return this;
    }

    @ApiModelProperty(value="Array of UUID of group")
    @JsonProperty(value="del_groups")
    public List<String> getDelGroups() {
        return this.delGroups;
    }

    @JsonProperty(value="del_groups")
    public void setDelGroups(List<String> delGroups) {
        this.delGroups = delGroups;
    }

    public AppRequest modGroups(Map<String, List<AppPermissions>> modGroups) {
        this.modGroups = modGroups;
        return this;
    }

    public AppRequest putModGroupsItem(String key, List<AppPermissions> modGroupsItem) {
        if (this.modGroups == null) {
            this.modGroups = new HashMap<String, List<AppPermissions>>();
        }
        this.modGroups.put(key, modGroupsItem);
        return this;
    }

    @ApiModelProperty(value="Map from UUIDs to group permissions")
    @JsonProperty(value="mod_groups")
    public Map<String, List<AppPermissions>> getModGroups() {
        return this.modGroups;
    }

    @JsonProperty(value="mod_groups")
    public void setModGroups(Map<String, List<AppPermissions>> modGroups) {
        this.modGroups = modGroups;
    }

    public AppRequest defaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
        return this;
    }

    @ApiModelProperty(required=true, value="The default group of this application. This is the group where security objects will be created by default by this application.")
    @JsonProperty(value="default_group")
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @JsonProperty(value="default_group")
    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public AppRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether this application is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AppRequest appOauthConfig(AppOauthConfig appOauthConfig) {
        this.appOauthConfig = appOauthConfig;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="AppOauthConfig")
    public AppOauthConfig getAppOauthConfig() {
        return this.appOauthConfig;
    }

    @JsonProperty(value="AppOauthConfig")
    public void setAppOauthConfig(AppOauthConfig appOauthConfig) {
        this.appOauthConfig = appOauthConfig;
    }

    public AppRequest _interface(String _interface) {
        this._interface = _interface;
        return this;
    }

    @ApiModelProperty(value="Interface used with this application (PKCS11, CNG, JCE, KMIP, etc.).")
    @JsonProperty(value="interface")
    public String getInterface() {
        return this._interface;
    }

    @JsonProperty(value="interface")
    public void setInterface(String _interface) {
        this._interface = _interface;
    }

    public AppRequest appType(String appType) {
        this.appType = appType;
        return this;
    }

    @ApiModelProperty(value="The user-defined type of this application.")
    @JsonProperty(value="app_type")
    public String getAppType() {
        return this.appType;
    }

    @JsonProperty(value="app_type")
    public void setAppType(String appType) {
        this.appType = appType;
    }

    public AppRequest credential(AppCredential credential) {
        this.credential = credential;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="credential")
    public AppCredential getCredential() {
        return this.credential;
    }

    @JsonProperty(value="credential")
    public void setCredential(AppCredential credential) {
        this.credential = credential;
    }

    public AppRequest secretSize(Integer secretSize) {
        this.secretSize = secretSize;
        return this;
    }

    @ApiModelProperty(value="Size in bytes of app's secret.")
    @JsonProperty(value="secret_size")
    public Integer getSecretSize() {
        return this.secretSize;
    }

    @JsonProperty(value="secret_size")
    public void setSecretSize(Integer secretSize) {
        this.secretSize = secretSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppRequest appRequest = (AppRequest)o;
        return Objects.equals(this.name, appRequest.name) && Objects.equals(this.description, appRequest.description) && Objects.equals(this.addGroups, appRequest.addGroups) && Objects.equals(this.delGroups, appRequest.delGroups) && Objects.equals(this.modGroups, appRequest.modGroups) && Objects.equals(this.defaultGroup, appRequest.defaultGroup) && Objects.equals(this.enabled, appRequest.enabled) && Objects.equals(this.appOauthConfig, appRequest.appOauthConfig) && Objects.equals(this._interface, appRequest._interface) && Objects.equals(this.appType, appRequest.appType) && Objects.equals(this.credential, appRequest.credential) && Objects.equals(this.secretSize, appRequest.secretSize);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.addGroups, this.delGroups, this.modGroups, this.defaultGroup, this.enabled, this.appOauthConfig, this._interface, this.appType, this.credential, this.secretSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    addGroups: ").append(this.toIndentedString(this.addGroups)).append("\n");
        sb.append("    delGroups: ").append(this.toIndentedString(this.delGroups)).append("\n");
        sb.append("    modGroups: ").append(this.toIndentedString(this.modGroups)).append("\n");
        sb.append("    defaultGroup: ").append(this.toIndentedString(this.defaultGroup)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    appOauthConfig: ").append(this.toIndentedString(this.appOauthConfig)).append("\n");
        sb.append("    _interface: ").append(this.toIndentedString(this._interface)).append("\n");
        sb.append("    appType: ").append(this.toIndentedString(this.appType)).append("\n");
        sb.append("    credential: ").append(this.toIndentedString(this.credential)).append("\n");
        sb.append("    secretSize: ").append(this.toIndentedString(this.secretSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

