/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.ApprovalStatus;
import com.fortanix.sdkms.v1.model.ApprovalSubject;
import com.fortanix.sdkms.v1.model.Entity;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApprovalRequest {
    @JsonProperty(value="request_id")
    private String requestId = null;
    @JsonProperty(value="requester")
    private Entity requester = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="acct_id")
    private String acctId = null;
    @JsonProperty(value="operation")
    private String operation = null;
    @JsonProperty(value="method")
    private String method = null;
    @JsonProperty(value="body")
    private Object body = null;
    @JsonProperty(value="approvers")
    private List<Entity> approvers = new ArrayList<Entity>();
    @JsonProperty(value="denier")
    private Entity denier = null;
    @JsonProperty(value="status")
    private ApprovalStatus status = null;
    @JsonProperty(value="reviewers")
    private List<Entity> reviewers = new ArrayList<Entity>();
    @JsonProperty(value="subjects")
    private List<ApprovalSubject> subjects = new ArrayList<ApprovalSubject>();
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="expiry")
    private String expiry = null;

    public ApprovalRequest requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="UUID uniquely identifying this approval request.")
    @JsonProperty(value="request_id")
    public String getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="request_id")
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public ApprovalRequest requester(Entity requester) {
        this.requester = requester;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="requester")
    public Entity getRequester() {
        return this.requester;
    }

    @JsonProperty(value="requester")
    public void setRequester(Entity requester) {
        this.requester = requester;
    }

    public ApprovalRequest createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="When this approval request was created.")
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public ApprovalRequest acctId(String acctId) {
        this.acctId = acctId;
        return this;
    }

    @ApiModelProperty(required=true, value="The account ID of the account that this approval request belongs to.")
    @JsonProperty(value="acct_id")
    public String getAcctId() {
        return this.acctId;
    }

    @JsonProperty(value="acct_id")
    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public ApprovalRequest operation(String operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(required=true, value="Operation URL path, e.g. `/crypto/v1/keys`, `/crypto/v1/groups/<id>`.")
    @JsonProperty(value="operation")
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public ApprovalRequest method(String method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(required=true, value="Method for the operation: POST, PATCH, PUT, DELETE, or GET. Default is POST. ")
    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod(String method) {
        this.method = method;
    }

    public ApprovalRequest body(Object body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="body")
    public Object getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    public void setBody(Object body) {
        this.body = body;
    }

    public ApprovalRequest approvers(List<Entity> approvers) {
        this.approvers = approvers;
        return this;
    }

    public ApprovalRequest addApproversItem(Entity approversItem) {
        this.approvers.add(approversItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="approvers")
    public List<Entity> getApprovers() {
        return this.approvers;
    }

    @JsonProperty(value="approvers")
    public void setApprovers(List<Entity> approvers) {
        this.approvers = approvers;
    }

    public ApprovalRequest denier(Entity denier) {
        this.denier = denier;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="denier")
    public Entity getDenier() {
        return this.denier;
    }

    @JsonProperty(value="denier")
    public void setDenier(Entity denier) {
        this.denier = denier;
    }

    public ApprovalRequest status(ApprovalStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="status")
    public ApprovalStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(ApprovalStatus status) {
        this.status = status;
    }

    public ApprovalRequest reviewers(List<Entity> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public ApprovalRequest addReviewersItem(Entity reviewersItem) {
        this.reviewers.add(reviewersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="reviewers")
    public List<Entity> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    public void setReviewers(List<Entity> reviewers) {
        this.reviewers = reviewers;
    }

    public ApprovalRequest subjects(List<ApprovalSubject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public ApprovalRequest addSubjectsItem(ApprovalSubject subjectsItem) {
        this.subjects.add(subjectsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subjects")
    public List<ApprovalSubject> getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="subjects")
    public void setSubjects(List<ApprovalSubject> subjects) {
        this.subjects = subjects;
    }

    public ApprovalRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Optional comment about the approval request for the reviewer.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ApprovalRequest expiry(String expiry) {
        this.expiry = expiry;
        return this;
    }

    @ApiModelProperty(required=true, value="When this approval request expires.")
    @JsonProperty(value="expiry")
    public String getExpiry() {
        return this.expiry;
    }

    @JsonProperty(value="expiry")
    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalRequest approvalRequest = (ApprovalRequest)o;
        return Objects.equals(this.requestId, approvalRequest.requestId) && Objects.equals(this.requester, approvalRequest.requester) && Objects.equals(this.createdAt, approvalRequest.createdAt) && Objects.equals(this.acctId, approvalRequest.acctId) && Objects.equals(this.operation, approvalRequest.operation) && Objects.equals(this.method, approvalRequest.method) && Objects.equals(this.body, approvalRequest.body) && Objects.equals(this.approvers, approvalRequest.approvers) && Objects.equals(this.denier, approvalRequest.denier) && Objects.equals(this.status, approvalRequest.status) && Objects.equals(this.reviewers, approvalRequest.reviewers) && Objects.equals(this.subjects, approvalRequest.subjects) && Objects.equals(this.description, approvalRequest.description) && Objects.equals(this.expiry, approvalRequest.expiry);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.requester, this.createdAt, this.acctId, this.operation, this.method, this.body, this.approvers, this.denier, this.status, this.reviewers, this.subjects, this.description, this.expiry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApprovalRequest {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    requester: ").append(this.toIndentedString(this.requester)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    acctId: ").append(this.toIndentedString(this.acctId)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    approvers: ").append(this.toIndentedString(this.approvers)).append("\n");
        sb.append("    denier: ").append(this.toIndentedString(this.denier)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

