/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class AzureKeyVaultType {
    private String value;
    public static final AzureKeyVaultType STANDARD = new AzureKeyVaultType("STANDARD");
    public static final AzureKeyVaultType PREMIUM = new AzureKeyVaultType("PREMIUM");
    private static final Map<String, AzureKeyVaultType> valueMap = new HashMap<String, AzureKeyVaultType>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private AzureKeyVaultType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AzureKeyVaultType[] values() {
        valueMapLock.lock();
        try {
            AzureKeyVaultType[] azureKeyVaultTypeArray = valueMap.values().toArray(new AzureKeyVaultType[valueMap.values().size()]);
            return azureKeyVaultTypeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static AzureKeyVaultType fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                AzureKeyVaultType azureKeyVaultType = valueMap.get(val);
                return azureKeyVaultType;
            }
            AzureKeyVaultType newValue = new AzureKeyVaultType(val);
            valueMap.put(val, newValue);
            AzureKeyVaultType azureKeyVaultType = newValue;
            return azureKeyVaultType;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("STANDARD", STANDARD);
        valueMap.put("PREMIUM", PREMIUM);
    }
}

