/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class BlsVariant {
    private String value;
    public static final BlsVariant SIGNATURES = new BlsVariant("small_signatures");
    public static final BlsVariant PUBLIC_KEYS = new BlsVariant("small_public_keys");
    private static final Map<String, BlsVariant> valueMap = new HashMap<String, BlsVariant>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private BlsVariant(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlsVariant[] values() {
        valueMapLock.lock();
        try {
            BlsVariant[] blsVariantArray = valueMap.values().toArray(new BlsVariant[valueMap.values().size()]);
            return blsVariantArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static BlsVariant fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                BlsVariant blsVariant = valueMap.get(val);
                return blsVariant;
            }
            BlsVariant newValue = new BlsVariant(val);
            valueMap.put(val, newValue);
            BlsVariant blsVariant = newValue;
            return blsVariant;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("small_signatures", SIGNATURES);
        valueMap.put("small_public_keys", PUBLIC_KEYS);
    }
}

