/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class CryptMode {
    private String value;
    public static final CryptMode ECB = new CryptMode("ECB");
    public static final CryptMode CBC = new CryptMode("CBC");
    public static final CryptMode CBCNOPAD = new CryptMode("CBCNOPAD");
    public static final CryptMode CFB = new CryptMode("CFB");
    public static final CryptMode CTR = new CryptMode("CTR");
    public static final CryptMode OFB = new CryptMode("OFB");
    public static final CryptMode GCM = new CryptMode("GCM");
    public static final CryptMode CCM = new CryptMode("CCM");
    public static final CryptMode PKCS1_V15 = new CryptMode("PKCS1_V15");
    public static final CryptMode OAEP_MGF1_SHA1 = new CryptMode("OAEP_MGF1_SHA1");
    public static final CryptMode OAEP_MGF1_SHA256 = new CryptMode("OAEP_MGF1_SHA256");
    public static final CryptMode OAEP_MGF1_SHA384 = new CryptMode("OAEP_MGF1_SHA384");
    public static final CryptMode OAEP_MGF1_SHA512 = new CryptMode("OAEP_MGF1_SHA512");
    public static final CryptMode FPE = new CryptMode("FPE");
    public static final CryptMode KW = new CryptMode("KW");
    public static final CryptMode KWP = new CryptMode("KWP");
    public static final CryptMode FF1 = new CryptMode("FF1");
    private static final Map<String, CryptMode> valueMap = new HashMap<String, CryptMode>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private CryptMode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CryptMode[] values() {
        valueMapLock.lock();
        try {
            CryptMode[] cryptModeArray = valueMap.values().toArray(new CryptMode[valueMap.values().size()]);
            return cryptModeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static CryptMode fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                CryptMode cryptMode = valueMap.get(val);
                return cryptMode;
            }
            CryptMode newValue = new CryptMode(val);
            valueMap.put(val, newValue);
            CryptMode cryptMode = newValue;
            return cryptMode;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("ECB", ECB);
        valueMap.put("CBC", CBC);
        valueMap.put("CBCNOPAD", CBCNOPAD);
        valueMap.put("CFB", CFB);
        valueMap.put("CTR", CTR);
        valueMap.put("OFB", OFB);
        valueMap.put("GCM", GCM);
        valueMap.put("CCM", CCM);
        valueMap.put("PKCS1_V15", PKCS1_V15);
        valueMap.put("OAEP_MGF1_SHA1", OAEP_MGF1_SHA1);
        valueMap.put("OAEP_MGF1_SHA256", OAEP_MGF1_SHA256);
        valueMap.put("OAEP_MGF1_SHA384", OAEP_MGF1_SHA384);
        valueMap.put("OAEP_MGF1_SHA512", OAEP_MGF1_SHA512);
        valueMap.put("FPE", FPE);
        valueMap.put("KW", KW);
        valueMap.put("KWP", KWP);
        valueMap.put("FF1", FF1);
    }
}

