/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Mode and iv are required fields for symmetric key algorithms and ad and tag are required fields for GCM or CCM modes.")
public class DecryptRequest {
    @JsonProperty(value="alg")
    private ObjectType alg = null;
    @JsonProperty(value="cipher")
    private byte[] cipher = null;
    @JsonProperty(value="mode")
    private CryptMode mode = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;
    @JsonProperty(value="tag")
    private byte[] tag = null;
    @JsonProperty(value="masked")
    private Boolean masked = null;

    public DecryptRequest alg(ObjectType alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="alg")
    public ObjectType getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    public void setAlg(ObjectType alg) {
        this.alg = alg;
    }

    public DecryptRequest cipher(byte[] cipher) {
        this.cipher = cipher;
        return this;
    }

    @ApiModelProperty(required=true, value="The ciphertext to decrypt.")
    @JsonProperty(value="cipher")
    public byte[] getCipher() {
        return this.cipher;
    }

    @JsonProperty(value="cipher")
    public void setCipher(byte[] cipher) {
        this.cipher = cipher;
    }

    public DecryptRequest mode(CryptMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public CryptMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CryptMode mode) {
        this.mode = mode;
    }

    public DecryptRequest iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="The initialization value used to encrypt this ciphertext. This field is required for symmetric ciphers, and ignored for asymmetric ciphers. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public DecryptRequest ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="The authenticated data used with this ciphertext and authentication tag. This field is required for symmetric ciphers using cipher mode GCM or CCM, and must not be specified for all other ciphers. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public DecryptRequest tag(byte[] tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(value="The authentication tag used with this ciphertext and authenticated data. This field is required for symmetric ciphers using cipher mode GCM or CCM, and must not be specified for all other ciphers. ")
    @JsonProperty(value="tag")
    public byte[] getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    public void setTag(byte[] tag) {
        this.tag = tag;
    }

    public DecryptRequest masked(Boolean masked) {
        this.masked = masked;
        return this;
    }

    @ApiModelProperty(value="This flag is only useful with DECRYPT permission. When this flag is true, decryption returns masked output. Setting it to false is equivalent to not using this flag. With MASKDECRYPT permission, this flag is ignored. ")
    @JsonProperty(value="masked")
    public Boolean getMasked() {
        return this.masked;
    }

    @JsonProperty(value="masked")
    public void setMasked(Boolean masked) {
        this.masked = masked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecryptRequest decryptRequest = (DecryptRequest)o;
        return Objects.equals(this.alg, decryptRequest.alg) && Objects.equals(this.cipher, decryptRequest.cipher) && Objects.equals(this.mode, decryptRequest.mode) && Objects.equals(this.iv, decryptRequest.iv) && Objects.equals(this.ad, decryptRequest.ad) && Objects.equals(this.tag, decryptRequest.tag) && Objects.equals(this.masked, decryptRequest.masked);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.cipher, this.mode, this.iv, this.ad, this.tag, this.masked);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecryptRequest {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    cipher: ").append(this.toIndentedString(this.cipher)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    masked: ").append(this.toIndentedString(this.masked)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

