/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.EncryptResponseFrameError;
import com.fortanix.sdkms.v1.model.EncryptResponseFrameFinal;
import com.fortanix.sdkms.v1.model.EncryptResponseFrameInit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A single frame of an encrypt response.  Each frame is a CBOR map with exactly one string key: \"init\", \"cipher\", \"final\", or \"error\". ")
public class EncryptResponseFrame {
    @JsonProperty(value="init")
    private EncryptResponseFrameInit init = null;
    @JsonProperty(value="cipher")
    private byte[] cipher = null;
    @JsonProperty(value="final")
    private EncryptResponseFrameFinal _final = null;
    @JsonProperty(value="error")
    private EncryptResponseFrameError error = null;

    public EncryptResponseFrame init(EncryptResponseFrameInit init) {
        this.init = init;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="init")
    public EncryptResponseFrameInit getInit() {
        return this.init;
    }

    @JsonProperty(value="init")
    public void setInit(EncryptResponseFrameInit init) {
        this.init = init;
    }

    public EncryptResponseFrame cipher(byte[] cipher) {
        this.cipher = cipher;
        return this;
    }

    @ApiModelProperty(value="A chunk of ciphertext.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string. ")
    @JsonProperty(value="cipher")
    public byte[] getCipher() {
        return this.cipher;
    }

    @JsonProperty(value="cipher")
    public void setCipher(byte[] cipher) {
        this.cipher = cipher;
    }

    public EncryptResponseFrame _final(EncryptResponseFrameFinal _final) {
        this._final = _final;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="final")
    public EncryptResponseFrameFinal getFinal() {
        return this._final;
    }

    @JsonProperty(value="final")
    public void setFinal(EncryptResponseFrameFinal _final) {
        this._final = _final;
    }

    public EncryptResponseFrame error(EncryptResponseFrameError error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="error")
    public EncryptResponseFrameError getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    public void setError(EncryptResponseFrameError error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptResponseFrame encryptResponseFrame = (EncryptResponseFrame)o;
        return Objects.equals(this.init, encryptResponseFrame.init) && Objects.equals(this.cipher, encryptResponseFrame.cipher) && Objects.equals(this._final, encryptResponseFrame._final) && Objects.equals(this.error, encryptResponseFrame.error);
    }

    public int hashCode() {
        return Objects.hash(this.init, this.cipher, this._final, this.error);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncryptResponseFrame {\n");
        sb.append("    init: ").append(this.toIndentedString(this.init)).append("\n");
        sb.append("    cipher: ").append(this.toIndentedString(this.cipher)).append("\n");
        sb.append("    _final: ").append(this.toIndentedString(this._final)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

