/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.SobjectComponent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Response of security object export components operation")
public class ExportComponentsResponse {
    @JsonProperty(value="components")
    private List<SobjectComponent> components = new ArrayList<SobjectComponent>();
    @JsonProperty(value="key_kcv")
    private byte[] keyKcv = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="tag")
    private byte[] tag = null;

    public ExportComponentsResponse components(List<SobjectComponent> components) {
        this.components = components;
        return this;
    }

    public ExportComponentsResponse addComponentsItem(SobjectComponent componentsItem) {
        this.components.add(componentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Components of the Security Object")
    @JsonProperty(value="components")
    public List<SobjectComponent> getComponents() {
        return this.components;
    }

    @JsonProperty(value="components")
    public void setComponents(List<SobjectComponent> components) {
        this.components = components;
    }

    public ExportComponentsResponse keyKcv(byte[] keyKcv) {
        this.keyKcv = keyKcv;
        return this;
    }

    @ApiModelProperty(required=true, value="KCV for the entire Security Object")
    @JsonProperty(value="key_kcv")
    public byte[] getKeyKcv() {
        return this.keyKcv;
    }

    @JsonProperty(value="key_kcv")
    public void setKeyKcv(byte[] keyKcv) {
        this.keyKcv = keyKcv;
    }

    public ExportComponentsResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="optional description to the export request")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ExportComponentsResponse iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers, this value will be used for the cipher initialization value. If not provided, DSM will generate a random iv and return it in the response. If provided, iv length must match the length required by the cipher and mode. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public ExportComponentsResponse tag(byte[] tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers with cipher mode GCM or CCM, the authentication tag produced by the cipher. Its length will match the tag length specified by the encryption request. ")
    @JsonProperty(value="tag")
    public byte[] getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    public void setTag(byte[] tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportComponentsResponse exportComponentsResponse = (ExportComponentsResponse)o;
        return Objects.equals(this.components, exportComponentsResponse.components) && Objects.equals(this.keyKcv, exportComponentsResponse.keyKcv) && Objects.equals(this.description, exportComponentsResponse.description) && Objects.equals(this.iv, exportComponentsResponse.iv) && Objects.equals(this.tag, exportComponentsResponse.tag);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.keyKcv, this.description, this.iv, this.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportComponentsResponse {\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    keyKcv: ").append(this.toIndentedString(this.keyKcv)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

