/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CreatorType;
import com.fortanix.sdkms.v1.model.HmgConfig;
import com.fortanix.sdkms.v1.model.KeyUndoPolicy;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Group {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="group_id")
    private String groupId = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="acct_id")
    private String acctId = null;
    @JsonProperty(value="creator")
    private CreatorType creator = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="hmg")
    private Map<String, HmgConfig> hmg = null;
    @JsonProperty(value="key_undo_policy")
    private KeyUndoPolicy keyUndoPolicy = null;

    public Group name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the group. Group names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Group groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="Group ID uniquely identifying this group.")
    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Group description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the group.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Group acctId(String acctId) {
        this.acctId = acctId;
        return this;
    }

    @ApiModelProperty(value="Account ID of the account this Group belongs to.")
    @JsonProperty(value="acct_id")
    public String getAcctId() {
        return this.acctId;
    }

    @JsonProperty(value="acct_id")
    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public Group creator(CreatorType creator) {
        this.creator = creator;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="creator")
    public CreatorType getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    public void setCreator(CreatorType creator) {
        this.creator = creator;
    }

    public Group createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="When this group was created.")
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Group hmg(Map<String, HmgConfig> hmg) {
        this.hmg = hmg;
        return this;
    }

    public Group putHmgItem(String key, HmgConfig hmgItem) {
        if (this.hmg == null) {
            this.hmg = new HashMap<String, HmgConfig>();
        }
        this.hmg.put(key, hmgItem);
        return this;
    }

    @ApiModelProperty(value="Map from UUIDs to HmgConfig objects")
    @JsonProperty(value="hmg")
    public Map<String, HmgConfig> getHmg() {
        return this.hmg;
    }

    @JsonProperty(value="hmg")
    public void setHmg(Map<String, HmgConfig> hmg) {
        this.hmg = hmg;
    }

    public Group keyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="key_undo_policy")
    public KeyUndoPolicy getKeyUndoPolicy() {
        return this.keyUndoPolicy;
    }

    @JsonProperty(value="key_undo_policy")
    public void setKeyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        return Objects.equals(this.name, group.name) && Objects.equals(this.groupId, group.groupId) && Objects.equals(this.description, group.description) && Objects.equals(this.acctId, group.acctId) && Objects.equals(this.creator, group.creator) && Objects.equals(this.createdAt, group.createdAt) && Objects.equals(this.hmg, group.hmg) && Objects.equals(this.keyUndoPolicy, group.keyUndoPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.groupId, this.description, this.acctId, this.creator, this.createdAt, this.hmg, this.keyUndoPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Group {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    acctId: ").append(this.toIndentedString(this.acctId)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    hmg: ").append(this.toIndentedString(this.hmg)).append("\n");
        sb.append("    keyUndoPolicy: ").append(this.toIndentedString(this.keyUndoPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

