/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.KeyObjectState;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.RevocationReasonCode;
import com.fortanix.sdkms.v1.model.RotationPolicy;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HistoryItemState {
    @JsonProperty(value="activation_date")
    private String activationDate = null;
    @JsonProperty(value="revocation_reason")
    private RevocationReasonCode revocationReason = null;
    @JsonProperty(value="compromise_date")
    private String compromiseDate = null;
    @JsonProperty(value="deactivation_date")
    private String deactivationDate = null;
    @JsonProperty(value="destruction_date")
    private String destructionDate = null;
    @JsonProperty(value="deletion_date")
    private String deletionDate = null;
    @JsonProperty(value="state")
    private KeyObjectState state = null;
    @JsonProperty(value="key_ops")
    private List<KeyOperations> keyOps = null;
    @JsonProperty(value="public_only")
    private Boolean publicOnly = null;
    @JsonProperty(value="rotation_policy")
    private RotationPolicy rotationPolicy = null;
    @JsonProperty(value="group_id")
    private String groupId = null;

    public HistoryItemState activationDate(String activationDate) {
        this.activationDate = activationDate;
        return this;
    }

    @ApiModelProperty(value="When this KeyObject will become active")
    @JsonProperty(value="activation_date")
    public String getActivationDate() {
        return this.activationDate;
    }

    @JsonProperty(value="activation_date")
    public void setActivationDate(String activationDate) {
        this.activationDate = activationDate;
    }

    public HistoryItemState revocationReason(RevocationReasonCode revocationReason) {
        this.revocationReason = revocationReason;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="revocation_reason")
    public RevocationReasonCode getRevocationReason() {
        return this.revocationReason;
    }

    @JsonProperty(value="revocation_reason")
    public void setRevocationReason(RevocationReasonCode revocationReason) {
        this.revocationReason = revocationReason;
    }

    public HistoryItemState compromiseDate(String compromiseDate) {
        this.compromiseDate = compromiseDate;
        return this;
    }

    @ApiModelProperty(value="When this security object was compromised.")
    @JsonProperty(value="compromise_date")
    public String getCompromiseDate() {
        return this.compromiseDate;
    }

    @JsonProperty(value="compromise_date")
    public void setCompromiseDate(String compromiseDate) {
        this.compromiseDate = compromiseDate;
    }

    public HistoryItemState deactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
        return this;
    }

    @ApiModelProperty(value="When this security object was deactivated")
    @JsonProperty(value="deactivation_date")
    public String getDeactivationDate() {
        return this.deactivationDate;
    }

    @JsonProperty(value="deactivation_date")
    public void setDeactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
    }

    public HistoryItemState destructionDate(String destructionDate) {
        this.destructionDate = destructionDate;
        return this;
    }

    @ApiModelProperty(value="When this security object was destroyed")
    @JsonProperty(value="destruction_date")
    public String getDestructionDate() {
        return this.destructionDate;
    }

    @JsonProperty(value="destruction_date")
    public void setDestructionDate(String destructionDate) {
        this.destructionDate = destructionDate;
    }

    public HistoryItemState deletionDate(String deletionDate) {
        this.deletionDate = deletionDate;
        return this;
    }

    @ApiModelProperty(value="When the security object was deleted")
    @JsonProperty(value="deletion_date")
    public String getDeletionDate() {
        return this.deletionDate;
    }

    @JsonProperty(value="deletion_date")
    public void setDeletionDate(String deletionDate) {
        this.deletionDate = deletionDate;
    }

    public HistoryItemState state(KeyObjectState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    public KeyObjectState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(KeyObjectState state) {
        this.state = state;
    }

    public HistoryItemState keyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public HistoryItemState addKeyOpsItem(KeyOperations keyOpsItem) {
        if (this.keyOps == null) {
            this.keyOps = new ArrayList<KeyOperations>();
        }
        this.keyOps.add(keyOpsItem);
        return this;
    }

    @ApiModelProperty(value="Array of key operations enabled for this security object. ")
    @JsonProperty(value="key_ops")
    public List<KeyOperations> getKeyOps() {
        return this.keyOps;
    }

    @JsonProperty(value="key_ops")
    public void setKeyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
    }

    public HistoryItemState publicOnly(Boolean publicOnly) {
        this.publicOnly = publicOnly;
        return this;
    }

    @ApiModelProperty(value="Whether the key object contains only a public part")
    @JsonProperty(value="public_only")
    public Boolean getPublicOnly() {
        return this.publicOnly;
    }

    @JsonProperty(value="public_only")
    public void setPublicOnly(Boolean publicOnly) {
        this.publicOnly = publicOnly;
    }

    public HistoryItemState rotationPolicy(RotationPolicy rotationPolicy) {
        this.rotationPolicy = rotationPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="rotation_policy")
    public RotationPolicy getRotationPolicy() {
        return this.rotationPolicy;
    }

    @JsonProperty(value="rotation_policy")
    public void setRotationPolicy(RotationPolicy rotationPolicy) {
        this.rotationPolicy = rotationPolicy;
    }

    public HistoryItemState groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="Group ID (UUID) of the security group that this security object belonged to. Expect this property to always exist.")
    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryItemState historyItemState = (HistoryItemState)o;
        return Objects.equals(this.activationDate, historyItemState.activationDate) && Objects.equals(this.revocationReason, historyItemState.revocationReason) && Objects.equals(this.compromiseDate, historyItemState.compromiseDate) && Objects.equals(this.deactivationDate, historyItemState.deactivationDate) && Objects.equals(this.destructionDate, historyItemState.destructionDate) && Objects.equals(this.deletionDate, historyItemState.deletionDate) && Objects.equals(this.state, historyItemState.state) && Objects.equals(this.keyOps, historyItemState.keyOps) && Objects.equals(this.publicOnly, historyItemState.publicOnly) && Objects.equals(this.rotationPolicy, historyItemState.rotationPolicy) && Objects.equals(this.groupId, historyItemState.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.activationDate, this.revocationReason, this.compromiseDate, this.deactivationDate, this.destructionDate, this.deletionDate, this.state, this.keyOps, this.publicOnly, this.rotationPolicy, this.groupId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryItemState {\n");
        sb.append("    activationDate: ").append(this.toIndentedString(this.activationDate)).append("\n");
        sb.append("    revocationReason: ").append(this.toIndentedString(this.revocationReason)).append("\n");
        sb.append("    compromiseDate: ").append(this.toIndentedString(this.compromiseDate)).append("\n");
        sb.append("    deactivationDate: ").append(this.toIndentedString(this.deactivationDate)).append("\n");
        sb.append("    destructionDate: ").append(this.toIndentedString(this.destructionDate)).append("\n");
        sb.append("    deletionDate: ").append(this.toIndentedString(this.deletionDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    keyOps: ").append(this.toIndentedString(this.keyOps)).append("\n");
        sb.append("    publicOnly: ").append(this.toIndentedString(this.publicOnly)).append("\n");
        sb.append("    rotationPolicy: ").append(this.toIndentedString(this.rotationPolicy)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

