/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ObjectOrigin {
    private String value;
    public static final ObjectOrigin FORTANIXHSM = new ObjectOrigin("FortanixHSM");
    public static final ObjectOrigin EXTERNAL = new ObjectOrigin("External");
    private static final Map<String, ObjectOrigin> valueMap = new HashMap<String, ObjectOrigin>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private ObjectOrigin(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectOrigin[] values() {
        valueMapLock.lock();
        try {
            ObjectOrigin[] objectOriginArray = valueMap.values().toArray(new ObjectOrigin[valueMap.values().size()]);
            return objectOriginArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static ObjectOrigin fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                ObjectOrigin objectOrigin = valueMap.get(val);
                return objectOrigin;
            }
            ObjectOrigin newValue = new ObjectOrigin(val);
            valueMap.put(val, newValue);
            ObjectOrigin objectOrigin = newValue;
            return objectOrigin;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("FortanixHSM", FORTANIXHSM);
        valueMap.put("External", EXTERNAL);
    }
}

