/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.KeyOperations;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PersistTransientKeyRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="custom_metadata")
    private Map<String, String> customMetadata = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="key_ops")
    private List<KeyOperations> keyOps = null;
    @JsonProperty(value="group_id")
    private String groupId = null;
    @JsonProperty(value="transient_key")
    private String transientKey = null;

    public PersistTransientKeyRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the persisted security object. Security object names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public PersistTransientKeyRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the persisted security object.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public PersistTransientKeyRequest customMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public PersistTransientKeyRequest putCustomMetadataItem(String key, String customMetadataItem) {
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, customMetadataItem);
        return this;
    }

    @ApiModelProperty(value="User-defined metadata for the persisted key. Stored as key-value pairs.")
    @JsonProperty(value="custom_metadata")
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public PersistTransientKeyRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether the new security object should be enabled. Disabled security objects may not perform cryptographic operations. ")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PersistTransientKeyRequest keyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public PersistTransientKeyRequest addKeyOpsItem(KeyOperations keyOpsItem) {
        if (this.keyOps == null) {
            this.keyOps = new ArrayList<KeyOperations>();
        }
        this.keyOps.add(keyOpsItem);
        return this;
    }

    @ApiModelProperty(value="Optional array of key operations to be enabled for this security object. If this property is not provided, the DSM server will provide a default set of key operations. Note that if you provide an empty array, all key operations will be disabled. ")
    @JsonProperty(value="key_ops")
    public List<KeyOperations> getKeyOps() {
        return this.keyOps;
    }

    @JsonProperty(value="key_ops")
    public void setKeyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
    }

    public PersistTransientKeyRequest groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="Group ID (not name) of the security group that the persisted security object should belong to. The user or application creating this security object must be a member of this group. If no group is specified, the default group for the user or application will be used. ")
    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public PersistTransientKeyRequest transientKey(String transientKey) {
        this.transientKey = transientKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Transient key blob.")
    @JsonProperty(value="transient_key")
    public String getTransientKey() {
        return this.transientKey;
    }

    @JsonProperty(value="transient_key")
    public void setTransientKey(String transientKey) {
        this.transientKey = transientKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistTransientKeyRequest persistTransientKeyRequest = (PersistTransientKeyRequest)o;
        return Objects.equals(this.name, persistTransientKeyRequest.name) && Objects.equals(this.description, persistTransientKeyRequest.description) && Objects.equals(this.customMetadata, persistTransientKeyRequest.customMetadata) && Objects.equals(this.enabled, persistTransientKeyRequest.enabled) && Objects.equals(this.keyOps, persistTransientKeyRequest.keyOps) && Objects.equals(this.groupId, persistTransientKeyRequest.groupId) && Objects.equals(this.transientKey, persistTransientKeyRequest.transientKey);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.customMetadata, this.enabled, this.keyOps, this.groupId, this.transientKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersistTransientKeyRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    keyOps: ").append(this.toIndentedString(this.keyOps)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    transientKey: ").append(this.toIndentedString(this.transientKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

