/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.RsaEncryptionPaddingOAEP;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Type of padding to use for RSA encryption. The use of PKCS#1 v1.5 padding is strongly discouraged, because of its susceptibility to Bleichenbacher's attack. The padding specified must adhere to the key's encryption policy, see `RsaEncryptionPolicy`. If not specified, the default based on the key's policy will be used. ")
public class RsaEncryptionPadding {
    @JsonProperty(value="PKCS1_V15")
    private Object pkCS1V15 = null;
    @JsonProperty(value="OAEP")
    private RsaEncryptionPaddingOAEP OAEP = null;

    public RsaEncryptionPadding pkCS1V15(Object pkCS1V15) {
        this.pkCS1V15 = pkCS1V15;
        return this;
    }

    @ApiModelProperty(value="PKCS#1 v1.5 padding")
    @JsonProperty(value="PKCS1_V15")
    public Object getPkCS1V15() {
        return this.pkCS1V15;
    }

    @JsonProperty(value="PKCS1_V15")
    public void setPkCS1V15(Object pkCS1V15) {
        this.pkCS1V15 = pkCS1V15;
    }

    public RsaEncryptionPadding OAEP(RsaEncryptionPaddingOAEP OAEP) {
        this.OAEP = OAEP;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="OAEP")
    public RsaEncryptionPaddingOAEP getOAEP() {
        return this.OAEP;
    }

    @JsonProperty(value="OAEP")
    public void setOAEP(RsaEncryptionPaddingOAEP OAEP) {
        this.OAEP = OAEP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RsaEncryptionPadding rsaEncryptionPadding = (RsaEncryptionPadding)o;
        return Objects.equals(this.pkCS1V15, rsaEncryptionPadding.pkCS1V15) && Objects.equals(this.OAEP, rsaEncryptionPadding.OAEP);
    }

    public int hashCode() {
        return Objects.hash(this.pkCS1V15, this.OAEP);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RsaEncryptionPadding {\n");
        sb.append("    pkCS1V15: ").append(this.toIndentedString(this.pkCS1V15)).append("\n");
        sb.append("    OAEP: ").append(this.toIndentedString(this.OAEP)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

