/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ServerMode {
    private String value;
    public static final ServerMode SOFTWARE = new ServerMode("Software");
    public static final ServerMode SGX = new ServerMode("Sgx");
    private static final Map<String, ServerMode> valueMap = new HashMap<String, ServerMode>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private ServerMode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerMode[] values() {
        valueMapLock.lock();
        try {
            ServerMode[] serverModeArray = valueMap.values().toArray(new ServerMode[valueMap.values().size()]);
            return serverModeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static ServerMode fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                ServerMode serverMode = valueMap.get(val);
                return serverMode;
            }
            ServerMode newValue = new ServerMode(val);
            valueMap.put(val, newValue);
            ServerMode serverMode = newValue;
            return serverMode;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Software", SOFTWARE);
        valueMap.put("Sgx", SGX);
    }
}

