/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CipherMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Security Object unwrapping parameters")
public class UnwrapKeyParams {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="alg")
    private ObjectType alg = null;
    @JsonProperty(value="mode")
    private CipherMode mode = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;
    @JsonProperty(value="tag_len")
    private Integer tagLen = null;

    public UnwrapKeyParams key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public UnwrapKeyParams alg(ObjectType alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="alg")
    public ObjectType getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    public void setAlg(ObjectType alg) {
        this.alg = alg;
    }

    public UnwrapKeyParams mode(CipherMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public CipherMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CipherMode mode) {
        this.mode = mode;
    }

    public UnwrapKeyParams iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers, this value will be used for the cipher initialization value. If not provided, DSM will generate a random iv and return it in the response. If provided, iv length must match the length required by the cipher and mode. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public UnwrapKeyParams ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers with cipher mode GCM or CCM, this optionally specifies the authenticated data used by the cipher. This field must not be provided with other cipher modes. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public UnwrapKeyParams tagLen(Integer tagLen) {
        this.tagLen = tagLen;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers with cipher mode GCM or CCM, this field specifies the length of the authentication tag to be produced. This field is specified in bits (not bytes). This field is required for symmetric ciphers with cipher mode GCM or CCM. It must not be specified for asymmetric ciphers and symmetric ciphers with other cipher modes.")
    @JsonProperty(value="tag_len")
    public Integer getTagLen() {
        return this.tagLen;
    }

    @JsonProperty(value="tag_len")
    public void setTagLen(Integer tagLen) {
        this.tagLen = tagLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnwrapKeyParams unwrapKeyParams = (UnwrapKeyParams)o;
        return Objects.equals(this.key, unwrapKeyParams.key) && Objects.equals(this.alg, unwrapKeyParams.alg) && Objects.equals(this.mode, unwrapKeyParams.mode) && Objects.equals(this.iv, unwrapKeyParams.iv) && Objects.equals(this.ad, unwrapKeyParams.ad) && Objects.equals(this.tagLen, unwrapKeyParams.tagLen);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.alg, this.mode, this.iv, this.ad, this.tagLen);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnwrapKeyParams {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("    tagLen: ").append(this.toIndentedString(this.tagLen)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

