/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.U2fAddDeviceRequest;
import com.fortanix.sdkms.v1.model.U2fDelDeviceRequest;
import com.fortanix.sdkms.v1.model.U2fRenameDeviceRequest;
import com.fortanix.sdkms.v1.model.UserAccountFlags;
import com.fortanix.sdkms.v1.model.UserGroupMap;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserRequest {
    @JsonProperty(value="user_email")
    private String userEmail = null;
    @JsonProperty(value="user_password")
    private String userPassword = null;
    @JsonProperty(value="first_name")
    private String firstName = null;
    @JsonProperty(value="last_name")
    private String lastName = null;
    @JsonProperty(value="account_role")
    private List<UserAccountFlags> accountRole = null;
    @JsonProperty(value="add_groups")
    private UserGroupMap addGroups = null;
    @JsonProperty(value="del_groups")
    private UserGroupMap delGroups = null;
    @JsonProperty(value="mod_groups")
    private UserGroupMap modGroups = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="add_u2f_devices")
    private List<U2fAddDeviceRequest> addU2fDevices = null;
    @JsonProperty(value="del_u2f_devices")
    private List<U2fDelDeviceRequest> delU2fDevices = null;
    @JsonProperty(value="rename_u2f_devices")
    private List<U2fRenameDeviceRequest> renameU2fDevices = null;

    public UserRequest userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @ApiModelProperty(required=true, value="User's email address.")
    @JsonProperty(value="user_email")
    public String getUserEmail() {
        return this.userEmail;
    }

    @JsonProperty(value="user_email")
    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public UserRequest userPassword(String userPassword) {
        this.userPassword = userPassword;
        return this;
    }

    @ApiModelProperty(required=true, value="The password to assign to this user in DSM.")
    @JsonProperty(value="user_password")
    public String getUserPassword() {
        return this.userPassword;
    }

    @JsonProperty(value="user_password")
    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public UserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="first_name")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="last_name")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="last_name")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserRequest accountRole(List<UserAccountFlags> accountRole) {
        this.accountRole = accountRole;
        return this;
    }

    public UserRequest addAccountRoleItem(UserAccountFlags accountRoleItem) {
        if (this.accountRole == null) {
            this.accountRole = new ArrayList<UserAccountFlags>();
        }
        this.accountRole.add(accountRoleItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="account_role")
    public List<UserAccountFlags> getAccountRole() {
        return this.accountRole;
    }

    @JsonProperty(value="account_role")
    public void setAccountRole(List<UserAccountFlags> accountRole) {
        this.accountRole = accountRole;
    }

    public UserRequest addGroups(UserGroupMap addGroups) {
        this.addGroups = addGroups;
        return this;
    }

    @ApiModelProperty(value="The user will be added to the specified security groups with the specified roles.")
    @JsonProperty(value="add_groups")
    public UserGroupMap getAddGroups() {
        return this.addGroups;
    }

    @JsonProperty(value="add_groups")
    public void setAddGroups(UserGroupMap addGroups) {
        this.addGroups = addGroups;
    }

    public UserRequest delGroups(UserGroupMap delGroups) {
        this.delGroups = delGroups;
        return this;
    }

    @ApiModelProperty(value="The user will be removed from the specified security groups.")
    @JsonProperty(value="del_groups")
    public UserGroupMap getDelGroups() {
        return this.delGroups;
    }

    @JsonProperty(value="del_groups")
    public void setDelGroups(UserGroupMap delGroups) {
        this.delGroups = delGroups;
    }

    public UserRequest modGroups(UserGroupMap modGroups) {
        this.modGroups = modGroups;
        return this;
    }

    @ApiModelProperty(value="The user's role in the specified groups will be updated to the specified roles.")
    @JsonProperty(value="mod_groups")
    public UserGroupMap getModGroups() {
        return this.modGroups;
    }

    @JsonProperty(value="mod_groups")
    public void setModGroups(UserGroupMap modGroups) {
        this.modGroups = modGroups;
    }

    public UserRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether this user is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UserRequest addU2fDevices(List<U2fAddDeviceRequest> addU2fDevices) {
        this.addU2fDevices = addU2fDevices;
        return this;
    }

    public UserRequest addAddU2fDevicesItem(U2fAddDeviceRequest addU2fDevicesItem) {
        if (this.addU2fDevices == null) {
            this.addU2fDevices = new ArrayList<U2fAddDeviceRequest>();
        }
        this.addU2fDevices.add(addU2fDevicesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="add_u2f_devices")
    public List<U2fAddDeviceRequest> getAddU2fDevices() {
        return this.addU2fDevices;
    }

    @JsonProperty(value="add_u2f_devices")
    public void setAddU2fDevices(List<U2fAddDeviceRequest> addU2fDevices) {
        this.addU2fDevices = addU2fDevices;
    }

    public UserRequest delU2fDevices(List<U2fDelDeviceRequest> delU2fDevices) {
        this.delU2fDevices = delU2fDevices;
        return this;
    }

    public UserRequest addDelU2fDevicesItem(U2fDelDeviceRequest delU2fDevicesItem) {
        if (this.delU2fDevices == null) {
            this.delU2fDevices = new ArrayList<U2fDelDeviceRequest>();
        }
        this.delU2fDevices.add(delU2fDevicesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="del_u2f_devices")
    public List<U2fDelDeviceRequest> getDelU2fDevices() {
        return this.delU2fDevices;
    }

    @JsonProperty(value="del_u2f_devices")
    public void setDelU2fDevices(List<U2fDelDeviceRequest> delU2fDevices) {
        this.delU2fDevices = delU2fDevices;
    }

    public UserRequest renameU2fDevices(List<U2fRenameDeviceRequest> renameU2fDevices) {
        this.renameU2fDevices = renameU2fDevices;
        return this;
    }

    public UserRequest addRenameU2fDevicesItem(U2fRenameDeviceRequest renameU2fDevicesItem) {
        if (this.renameU2fDevices == null) {
            this.renameU2fDevices = new ArrayList<U2fRenameDeviceRequest>();
        }
        this.renameU2fDevices.add(renameU2fDevicesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="rename_u2f_devices")
    public List<U2fRenameDeviceRequest> getRenameU2fDevices() {
        return this.renameU2fDevices;
    }

    @JsonProperty(value="rename_u2f_devices")
    public void setRenameU2fDevices(List<U2fRenameDeviceRequest> renameU2fDevices) {
        this.renameU2fDevices = renameU2fDevices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRequest userRequest = (UserRequest)o;
        return Objects.equals(this.userEmail, userRequest.userEmail) && Objects.equals(this.userPassword, userRequest.userPassword) && Objects.equals(this.firstName, userRequest.firstName) && Objects.equals(this.lastName, userRequest.lastName) && Objects.equals(this.accountRole, userRequest.accountRole) && Objects.equals(this.addGroups, userRequest.addGroups) && Objects.equals(this.delGroups, userRequest.delGroups) && Objects.equals(this.modGroups, userRequest.modGroups) && Objects.equals(this.enabled, userRequest.enabled) && Objects.equals(this.addU2fDevices, userRequest.addU2fDevices) && Objects.equals(this.delU2fDevices, userRequest.delU2fDevices) && Objects.equals(this.renameU2fDevices, userRequest.renameU2fDevices);
    }

    public int hashCode() {
        return Objects.hash(this.userEmail, this.userPassword, this.firstName, this.lastName, this.accountRole, this.addGroups, this.delGroups, this.modGroups, this.enabled, this.addU2fDevices, this.delU2fDevices, this.renameU2fDevices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRequest {\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    userPassword: ").append(this.toIndentedString(this.userPassword)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    accountRole: ").append(this.toIndentedString(this.accountRole)).append("\n");
        sb.append("    addGroups: ").append(this.toIndentedString(this.addGroups)).append("\n");
        sb.append("    delGroups: ").append(this.toIndentedString(this.delGroups)).append("\n");
        sb.append("    modGroups: ").append(this.toIndentedString(this.modGroups)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    addU2fDevices: ").append(this.toIndentedString(this.addU2fDevices)).append("\n");
        sb.append("    delU2fDevices: ").append(this.toIndentedString(this.delU2fDevices)).append("\n");
        sb.append("    renameU2fDevices: ").append(this.toIndentedString(this.renameU2fDevices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

