/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.KeyFormat;
import com.fortanix.sdkms.v1.model.ObjectType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class WrapKeyRequest {
    @JsonProperty(value="alg")
    private ObjectType alg = null;
    @JsonProperty(value="kid")
    private String kid = null;
    @JsonProperty(value="mode")
    private CryptMode mode = null;
    @JsonProperty(value="key_format")
    private KeyFormat keyFormat = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;
    @JsonProperty(value="tag_len")
    private Integer tagLen = null;

    public WrapKeyRequest alg(ObjectType alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="alg")
    public ObjectType getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    public void setAlg(ObjectType alg) {
        this.alg = alg;
    }

    public WrapKeyRequest kid(String kid) {
        this.kid = kid;
        return this;
    }

    @ApiModelProperty(required=true, value="The key ID (not name or description) of the key being wrapped.")
    @JsonProperty(value="kid")
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    public void setKid(String kid) {
        this.kid = kid;
    }

    public WrapKeyRequest mode(CryptMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public CryptMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CryptMode mode) {
        this.mode = mode;
    }

    public WrapKeyRequest keyFormat(KeyFormat keyFormat) {
        this.keyFormat = keyFormat;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="key_format")
    public KeyFormat getKeyFormat() {
        return this.keyFormat;
    }

    @JsonProperty(value="key_format")
    public void setKeyFormat(KeyFormat keyFormat) {
        this.keyFormat = keyFormat;
    }

    public WrapKeyRequest iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers, this value will be used for the cipher initialization value. If not provided, DSM will generate a random iv and return it in the response. If provided, iv length must match the length required by the cipher and mode. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public WrapKeyRequest ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers with cipher mode GCM or CCM, this optionally specifies the authenticated data used by the cipher. This field must not be provided with other cipher modes. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public WrapKeyRequest tagLen(Integer tagLen) {
        this.tagLen = tagLen;
        return this;
    }

    @ApiModelProperty(value="For symmetric ciphers with cipher mode GCM or CCM, this field specifies the length of the authentication tag to be produced. This field is specified in bits (not bytes). This field is required for symmetric ciphers with cipher mode GCM or CCM. It must not be specified for asymmetric ciphers and symmetric ciphers with other cipher modes.")
    @JsonProperty(value="tag_len")
    public Integer getTagLen() {
        return this.tagLen;
    }

    @JsonProperty(value="tag_len")
    public void setTagLen(Integer tagLen) {
        this.tagLen = tagLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrapKeyRequest wrapKeyRequest = (WrapKeyRequest)o;
        return Objects.equals(this.alg, wrapKeyRequest.alg) && Objects.equals(this.kid, wrapKeyRequest.kid) && Objects.equals(this.mode, wrapKeyRequest.mode) && Objects.equals(this.keyFormat, wrapKeyRequest.keyFormat) && Objects.equals(this.iv, wrapKeyRequest.iv) && Objects.equals(this.ad, wrapKeyRequest.ad) && Objects.equals(this.tagLen, wrapKeyRequest.tagLen);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.kid, this.mode, this.keyFormat, this.iv, this.ad, this.tagLen);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WrapKeyRequest {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    keyFormat: ").append(this.toIndentedString(this.keyFormat)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("    tagLen: ").append(this.toIndentedString(this.tagLen)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

