/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.api;

import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.Configuration;
import com.fortanix.sdkms.v1.Pair;
import com.fortanix.sdkms.v1.model.StatsResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class StatsApi {
    private ApiClient apiClient;

    public StatsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StatsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public StatsResponse getAppStats(String appId, Integer rangeFrom, Integer rangeTo, Integer numPoints) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getAppStats");
        }
        String localVarPath = "/sys/v1/stats/{app-id}/app".replaceAll("\\{app-id\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_from", rangeFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_to", rangeTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "num_points", numPoints));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<StatsResponse> localVarReturnType = new GenericType<StatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StatsResponse getAppsStats(Integer rangeFrom, Integer rangeTo, Integer topCount, Integer numPoints) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sys/v1/stats/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_from", rangeFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_to", rangeTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "top_count", topCount));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "num_points", numPoints));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<StatsResponse> localVarReturnType = new GenericType<StatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StatsResponse getGroupStats(String groupId, Integer rangeFrom, Integer rangeTo, Integer numPoints) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupStats");
        }
        String localVarPath = "/sys/v1/stats/{group-id}/group".replaceAll("\\{group-id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_from", rangeFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_to", rangeTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "num_points", numPoints));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<StatsResponse> localVarReturnType = new GenericType<StatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StatsResponse getGroupsStats(Integer rangeFrom, Integer rangeTo, Integer topCount, Integer numPoints) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sys/v1/stats/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_from", rangeFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_to", rangeTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "top_count", topCount));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "num_points", numPoints));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<StatsResponse> localVarReturnType = new GenericType<StatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StatsResponse getSecurityObjectStats(String keyId, Integer rangeFrom, Integer rangeTo, Integer numPoints) throws ApiException {
        Object localVarPostBody = null;
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getSecurityObjectStats");
        }
        String localVarPath = "/sys/v1/stats/{key-id}/key".replaceAll("\\{key-id\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_from", rangeFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "range_to", rangeTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "num_points", numPoints));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<StatsResponse> localVarReturnType = new GenericType<StatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

