/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AgreeKeyMechanism {
    private String value;
    public static final AgreeKeyMechanism HELLMAN = new AgreeKeyMechanism("diffie_hellman");
    private static final Map<String, AgreeKeyMechanism> valueMap = new HashMap<String, AgreeKeyMechanism>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private AgreeKeyMechanism(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgreeKeyMechanism[] values() {
        valueMapLock.lock();
        try {
            AgreeKeyMechanism[] agreeKeyMechanismArray = valueMap.values().toArray(new AgreeKeyMechanism[valueMap.values().size()]);
            return agreeKeyMechanismArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static AgreeKeyMechanism fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                AgreeKeyMechanism agreeKeyMechanism = valueMap.get(val);
                return agreeKeyMechanism;
            }
            AgreeKeyMechanism newValue = new AgreeKeyMechanism(val);
            valueMap.put(val, newValue);
            AgreeKeyMechanism agreeKeyMechanism = newValue;
            return agreeKeyMechanism;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("diffie_hellman", HELLMAN);
    }
}

