/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.JWTSigningKeyType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details of signning key that will be used for signature verification.")
@JsonIgnoreProperties(ignoreUnknown=true)
public class AppCredentialSignedjwtSigningKeys {
    @JsonProperty(value="kind")
    private JWTSigningKeyType kind = null;
    @JsonProperty(value="keys")
    private Map<String, String> keys = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="cache_duration")
    private Integer cacheDuration = null;

    public AppCredentialSignedjwtSigningKeys kind(JWTSigningKeyType kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of signing key, fetched or stored")
    @JsonProperty(value="kind")
    public JWTSigningKeyType getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(JWTSigningKeyType kind) {
        this.kind = kind;
    }

    public AppCredentialSignedjwtSigningKeys keys(Map<String, String> keys) {
        this.keys = keys;
        return this;
    }

    public AppCredentialSignedjwtSigningKeys putKeysItem(String key, String keysItem) {
        if (this.keys == null) {
            this.keys = new HashMap<String, String>();
        }
        this.keys.put(key, keysItem);
        return this;
    }

    @ApiModelProperty(value="In case of \"stored\" kind, a map of key ids (arbitrary strings) to base64-encoded DER keys")
    @JsonProperty(value="keys")
    public Map<String, String> getKeys() {
        return this.keys;
    }

    @JsonProperty(value="keys")
    public void setKeys(Map<String, String> keys) {
        this.keys = keys;
    }

    public AppCredentialSignedjwtSigningKeys url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="In case of \"fetched\" kind, URL for fetching public key for verification of JWT signature")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public AppCredentialSignedjwtSigningKeys cacheDuration(Integer cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

    @ApiModelProperty(value="In case of \"fetched\" kind, duration for which the public key can be cached")
    @JsonProperty(value="cache_duration")
    public Integer getCacheDuration() {
        return this.cacheDuration;
    }

    @JsonProperty(value="cache_duration")
    public void setCacheDuration(Integer cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppCredentialSignedjwtSigningKeys appCredentialSignedjwtSigningKeys = (AppCredentialSignedjwtSigningKeys)o;
        return Objects.equals(this.kind, appCredentialSignedjwtSigningKeys.kind) && Objects.equals(this.keys, appCredentialSignedjwtSigningKeys.keys) && Objects.equals(this.url, appCredentialSignedjwtSigningKeys.url) && Objects.equals(this.cacheDuration, appCredentialSignedjwtSigningKeys.cacheDuration);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.keys, this.url, this.cacheDuration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppCredentialSignedjwtSigningKeys {\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    keys: ").append(this.toIndentedString(this.keys)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    cacheDuration: ").append(this.toIndentedString(this.cacheDuration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

