/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.DecryptRequestFrameFinal;
import com.fortanix.sdkms.v1.model.DecryptRequestFrameInit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A single frame of a decrypt request.  Each frame is a CBOR map with exactly one string key: \"init\", \"ad\", \"cipher\", or \"final\". ")
@JsonIgnoreProperties(ignoreUnknown=true)
public class DecryptRequestFrame {
    @JsonProperty(value="init")
    private DecryptRequestFrameInit init = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;
    @JsonProperty(value="cipher")
    private byte[] cipher = null;
    @JsonProperty(value="final")
    private DecryptRequestFrameFinal _final = null;

    public DecryptRequestFrame init(DecryptRequestFrameInit init) {
        this.init = init;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="init")
    public DecryptRequestFrameInit getInit() {
        return this.init;
    }

    @JsonProperty(value="init")
    public void setInit(DecryptRequestFrameInit init) {
        this.init = init;
    }

    public DecryptRequestFrame ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="A chunk of additional data for authentication in AEAD modes.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string.  All \"ad\" frames must come before any \"cipher\" frames. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public DecryptRequestFrame cipher(byte[] cipher) {
        this.cipher = cipher;
        return this;
    }

    @ApiModelProperty(value="A chunk of ciphertext.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string.  In addition to the 512 KiB limit on the total size of all frames, the content of this field may be at most 511 KiB. ")
    @JsonProperty(value="cipher")
    public byte[] getCipher() {
        return this.cipher;
    }

    @JsonProperty(value="cipher")
    public void setCipher(byte[] cipher) {
        this.cipher = cipher;
    }

    public DecryptRequestFrame _final(DecryptRequestFrameFinal _final) {
        this._final = _final;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="final")
    public DecryptRequestFrameFinal getFinal() {
        return this._final;
    }

    @JsonProperty(value="final")
    public void setFinal(DecryptRequestFrameFinal _final) {
        this._final = _final;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecryptRequestFrame decryptRequestFrame = (DecryptRequestFrame)o;
        return Objects.equals(this.init, decryptRequestFrame.init) && Objects.equals(this.ad, decryptRequestFrame.ad) && Objects.equals(this.cipher, decryptRequestFrame.cipher) && Objects.equals(this._final, decryptRequestFrame._final);
    }

    public int hashCode() {
        return Objects.hash(this.init, this.ad, this.cipher, this._final);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecryptRequestFrame {\n");
        sb.append("    init: ").append(this.toIndentedString(this.init)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("    cipher: ").append(this.toIndentedString(this.cipher)).append("\n");
        sb.append("    _final: ").append(this.toIndentedString(this._final)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

