/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.HmgConfig;
import com.fortanix.sdkms.v1.model.KeyUndoPolicy;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="acct_id")
    private String acctId = null;
    @JsonProperty(value="add_hmg")
    private List<HmgConfig> addHmg = null;
    @JsonProperty(value="mod_hmg")
    private Map<String, HmgConfig> modHmg = null;
    @JsonProperty(value="del_hmg")
    private List<String> delHmg = null;
    @JsonProperty(value="key_undo_policy")
    private KeyUndoPolicy keyUndoPolicy = null;

    public GroupRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the group. Group names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GroupRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the group.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public GroupRequest acctId(String acctId) {
        this.acctId = acctId;
        return this;
    }

    @ApiModelProperty(value="Account ID of the account the new group will belong to.")
    @JsonProperty(value="acct_id")
    public String getAcctId() {
        return this.acctId;
    }

    @JsonProperty(value="acct_id")
    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public GroupRequest addHmg(List<HmgConfig> addHmg) {
        this.addHmg = addHmg;
        return this;
    }

    public GroupRequest addAddHmgItem(HmgConfig addHmgItem) {
        if (this.addHmg == null) {
            this.addHmg = new ArrayList<HmgConfig>();
        }
        this.addHmg.add(addHmgItem);
        return this;
    }

    @ApiModelProperty(value="List of HmgConfig objects to add")
    @JsonProperty(value="add_hmg")
    public List<HmgConfig> getAddHmg() {
        return this.addHmg;
    }

    @JsonProperty(value="add_hmg")
    public void setAddHmg(List<HmgConfig> addHmg) {
        this.addHmg = addHmg;
    }

    public GroupRequest modHmg(Map<String, HmgConfig> modHmg) {
        this.modHmg = modHmg;
        return this;
    }

    public GroupRequest putModHmgItem(String key, HmgConfig modHmgItem) {
        if (this.modHmg == null) {
            this.modHmg = new HashMap<String, HmgConfig>();
        }
        this.modHmg.put(key, modHmgItem);
        return this;
    }

    @ApiModelProperty(value="Map from UUIDs to HmgConfig objects to update")
    @JsonProperty(value="mod_hmg")
    public Map<String, HmgConfig> getModHmg() {
        return this.modHmg;
    }

    @JsonProperty(value="mod_hmg")
    public void setModHmg(Map<String, HmgConfig> modHmg) {
        this.modHmg = modHmg;
    }

    public GroupRequest delHmg(List<String> delHmg) {
        this.delHmg = delHmg;
        return this;
    }

    public GroupRequest addDelHmgItem(String delHmgItem) {
        if (this.delHmg == null) {
            this.delHmg = new ArrayList<String>();
        }
        this.delHmg.add(delHmgItem);
        return this;
    }

    @ApiModelProperty(value="List of HmgConfig UUIDs to delete")
    @JsonProperty(value="del_hmg")
    public List<String> getDelHmg() {
        return this.delHmg;
    }

    @JsonProperty(value="del_hmg")
    public void setDelHmg(List<String> delHmg) {
        this.delHmg = delHmg;
    }

    public GroupRequest keyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="key_undo_policy")
    public KeyUndoPolicy getKeyUndoPolicy() {
        return this.keyUndoPolicy;
    }

    @JsonProperty(value="key_undo_policy")
    public void setKeyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupRequest groupRequest = (GroupRequest)o;
        return Objects.equals(this.name, groupRequest.name) && Objects.equals(this.description, groupRequest.description) && Objects.equals(this.acctId, groupRequest.acctId) && Objects.equals(this.addHmg, groupRequest.addHmg) && Objects.equals(this.modHmg, groupRequest.modHmg) && Objects.equals(this.delHmg, groupRequest.delHmg) && Objects.equals(this.keyUndoPolicy, groupRequest.keyUndoPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.acctId, this.addHmg, this.modHmg, this.delHmg, this.keyUndoPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    acctId: ").append(this.toIndentedString(this.acctId)).append("\n");
        sb.append("    addHmg: ").append(this.toIndentedString(this.addHmg)).append("\n");
        sb.append("    modHmg: ").append(this.toIndentedString(this.modHmg)).append("\n");
        sb.append("    delHmg: ").append(this.toIndentedString(this.delHmg)).append("\n");
        sb.append("    keyUndoPolicy: ").append(this.toIndentedString(this.keyUndoPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

