/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PluginType {
    private String value;
    public static final PluginType STANDARD = new PluginType("Standard");
    public static final PluginType IMPERSONATING = new PluginType("Impersonating");
    public static final PluginType CUSTOMALGORITHM = new PluginType("CustomAlgorithm");
    private static final Map<String, PluginType> valueMap = new HashMap<String, PluginType>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private PluginType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PluginType[] values() {
        valueMapLock.lock();
        try {
            PluginType[] pluginTypeArray = valueMap.values().toArray(new PluginType[valueMap.values().size()]);
            return pluginTypeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static PluginType fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                PluginType pluginType = valueMap.get(val);
                return pluginType;
            }
            PluginType newValue = new PluginType(val);
            valueMap.put(val, newValue);
            PluginType pluginType = newValue;
            return pluginType;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Standard", STANDARD);
        valueMap.put("Impersonating", IMPERSONATING);
        valueMap.put("CustomAlgorithm", CUSTOMALGORITHM);
    }
}

