/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.SignatureMode;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SignRequest {
    @JsonProperty(value="hash_alg")
    private DigestAlgorithm hashAlg = null;
    @JsonProperty(value="hash")
    private byte[] hash = null;
    @JsonProperty(value="data")
    private byte[] data = null;
    @JsonProperty(value="mode")
    private SignatureMode mode = null;
    @JsonProperty(value="deterministic_signature")
    private Boolean deterministicSignature = null;

    public SignRequest hashAlg(DigestAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hash_alg")
    public DigestAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    @JsonProperty(value="hash_alg")
    public void setHashAlg(DigestAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public SignRequest hash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(value="Hash (not supported in FIPS mode) of the data to be signed. Exactly one of `hash` and `data` is required. ")
    @JsonProperty(value="hash")
    public byte[] getHash() {
        return this.hash;
    }

    @JsonProperty(value="hash")
    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public SignRequest data(byte[] data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="Data to be signed. Exactly one of `hash` and `data` is required. To reduce request size and avoid reaching the request size limit, prefer `hash`. When using Ed25519 keys, a distinction is made between providing the message directly in `data` and providing a prehashed value in `hash`. Providing a full message results in an \"Ed25519\" signature while providing `hash` results in an \"Ed25519ph\" signature, which is not compatible. See RFC 8032 for details. ")
    @JsonProperty(value="data")
    public byte[] getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(byte[] data) {
        this.data = data;
    }

    public SignRequest mode(SignatureMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public SignatureMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(SignatureMode mode) {
        this.mode = mode;
    }

    public SignRequest deterministicSignature(Boolean deterministicSignature) {
        this.deterministicSignature = deterministicSignature;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="deterministic_signature")
    public Boolean getDeterministicSignature() {
        return this.deterministicSignature;
    }

    @JsonProperty(value="deterministic_signature")
    public void setDeterministicSignature(Boolean deterministicSignature) {
        this.deterministicSignature = deterministicSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignRequest signRequest = (SignRequest)o;
        return Objects.equals(this.hashAlg, signRequest.hashAlg) && Objects.equals(this.hash, signRequest.hash) && Objects.equals(this.data, signRequest.data) && Objects.equals(this.mode, signRequest.mode) && Objects.equals(this.deterministicSignature, signRequest.deterministicSignature);
    }

    public int hashCode() {
        return Objects.hash(this.hashAlg, this.hash, this.data, this.mode, this.deterministicSignature);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignRequest {\n");
        sb.append("    hashAlg: ").append(this.toIndentedString(this.hashAlg)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    deterministicSignature: ").append(this.toIndentedString(this.deterministicSignature)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

