/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.SignatureMode;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SignRequestEx {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="hash_alg")
    private DigestAlgorithm hashAlg = null;
    @JsonProperty(value="hash")
    private byte[] hash = null;
    @JsonProperty(value="data")
    private byte[] data = null;
    @JsonProperty(value="mode")
    private SignatureMode mode = null;

    public SignRequestEx key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public SignRequestEx hashAlg(DigestAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hash_alg")
    public DigestAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    @JsonProperty(value="hash_alg")
    public void setHashAlg(DigestAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public SignRequestEx hash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(value="Hash (not supported in FIPS mode) of the data to be signed. Exactly one of `hash` and `data` is required. ")
    @JsonProperty(value="hash")
    public byte[] getHash() {
        return this.hash;
    }

    @JsonProperty(value="hash")
    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public SignRequestEx data(byte[] data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="Data to be signed. Exactly one of `hash` and `data` is required. To reduce request size and avoid reaching the request size limit, prefer `hash`. ")
    @JsonProperty(value="data")
    public byte[] getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(byte[] data) {
        this.data = data;
    }

    public SignRequestEx mode(SignatureMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public SignatureMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(SignatureMode mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignRequestEx signRequestEx = (SignRequestEx)o;
        return Objects.equals(this.key, signRequestEx.key) && Objects.equals(this.hashAlg, signRequestEx.hashAlg) && Objects.equals(this.hash, signRequestEx.hash) && Objects.equals(this.data, signRequestEx.data) && Objects.equals(this.mode, signRequestEx.mode);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.hashAlg, this.hash, this.data, this.mode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignRequestEx {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    hashAlg: ").append(this.toIndentedString(this.hashAlg)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

