/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserGroupFlags {
    private String value;
    public static final UserGroupFlags GROUPADMINISTRATOR = new UserGroupFlags("GroupAdministrator");
    public static final UserGroupFlags GROUPAUDITOR = new UserGroupFlags("GroupAuditor");
    private static final Map<String, UserGroupFlags> valueMap = new HashMap<String, UserGroupFlags>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private UserGroupFlags(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserGroupFlags[] values() {
        valueMapLock.lock();
        try {
            UserGroupFlags[] userGroupFlagsArray = valueMap.values().toArray(new UserGroupFlags[valueMap.values().size()]);
            return userGroupFlagsArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static UserGroupFlags fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                UserGroupFlags userGroupFlags = valueMap.get(val);
                return userGroupFlags;
            }
            UserGroupFlags newValue = new UserGroupFlags(val);
            valueMap.put(val, newValue);
            UserGroupFlags userGroupFlags = newValue;
            return userGroupFlags;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("GroupAdministrator", GROUPADMINISTRATOR);
        valueMap.put("GroupAuditor", GROUPAUDITOR);
    }
}

