/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1;

import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.JSON;
import com.fortanix.sdkms.v1.Pair;
import com.fortanix.sdkms.v1.RFC3339DateFormat;
import com.fortanix.sdkms.v1.StringUtil;
import com.fortanix.sdkms.v1.auth.ApiKeyAuth;
import com.fortanix.sdkms.v1.auth.Authentication;
import com.fortanix.sdkms.v1.auth.HttpBasicAuth;
import com.fortanix.sdkms.v1.auth.OAuth;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ApiClient {
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String basePath = "https://api.REGION.smartkey.io";
    private boolean debugging = false;
    private int connectionTimeout = 0;
    private int maxConnections = 0;
    private long keepAliveDuration = 5000L;
    private static final Logger log = Logger.getLogger(ApiClient.class.getName());
    private PoolingHttpClientConnectionManager connectionManager;
    private Client httpClient;
    private JSON json = new JSON();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat;

    public ApiClient() {
        this.setConnectionManager();
        this.httpClient = this.buildHttpClient(this.debugging);
        this.dateFormat = new RFC3339DateFormat();
        this.setUserAgent("Swagger-Codegen/4.30.2447/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("basicAuth", new HttpBasicAuth());
        this.authentications.put("bearerToken", new ApiKeyAuth("header", "Authorization"));
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public JSON getJSON() {
        return this.json;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setBasicAuthString(String authString) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setAuthString(authString);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.httpClient = this.buildHttpClient(debugging);
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.httpClient.property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
        return this;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public ApiClient setKeepAliveDuration(long keepAliveDuration) {
        this.keepAliveDuration = keepAliveDuration;
        this.httpClient = this.buildHttpClient(this.debugging);
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public ApiClient setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        this.setConnectionManager();
        this.httpClient = this.buildHttpClient(this.debugging);
        return this;
    }

    public PoolStats getConnectionStats() {
        if (this.maxConnections <= 0) {
            return null;
        }
        return this.connectionManager.getTotalStats();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        String format;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("csv".equals(format)) {
            delimiter = ",";
        } else if ("ssv".equals(format)) {
            delimiter = " ";
        } else if ("tsv".equals(format)) {
            delimiter = "\t";
        } else if ("pipes".equals(format)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equalsIgnoreCase("application/json-patch+json"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType) throws ApiException {
        Entity entity;
        if (contentType.startsWith("multipart/form-data")) {
            MultiPart multiPart = new MultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    FormDataContentDisposition contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)param.getKey()).fileName(file.getName())).size(file.length())).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                    continue;
                }
                FormDataContentDisposition contentDisp = FormDataContentDisposition.name((String)param.getKey()).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, this.parameterToString(param.getValue())));
            }
            entity = Entity.entity((Object)multiPart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE);
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                form.param(param.getKey(), this.parameterToString(param.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            entity = Entity.entity((Object)obj, (String)contentType);
        }
        return entity;
    }

    public <T> T deserialize(Response response, GenericType<T> returnType) throws ApiException {
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            return (T)response.readEntity(byte[].class);
        }
        if (returnType.getRawType() == File.class) {
            File file = this.downloadFileFromResponse(response);
            return (T)file;
        }
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = String.valueOf(contentTypes.get(0));
        }
        if (contentType == null) {
            throw new ApiException(500, "missing Content-Type in response");
        }
        return (T)response.readEntity(returnType);
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy((InputStream)response.readEntity(InputStream.class), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        String prefix;
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        Response response;
        block32: {
            String xRequestId;
            String localStatusCodeString;
            Long startTS;
            block33: {
                block31: {
                    T t;
                    startTS = System.currentTimeMillis();
                    this.updateParamsForAuth(authNames, queryParams, headerParams);
                    WebTarget target = this.httpClient.target(this.basePath + path);
                    if (queryParams != null) {
                        for (Pair pair : queryParams) {
                            if (pair.getValue() == null) continue;
                            target = target.queryParam(pair.getName(), new Object[]{pair.getValue()});
                        }
                    }
                    Invocation.Builder invocationBuilder = target.request().accept(new String[]{accept});
                    for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                        String value = entry.getValue();
                        if (value == null) continue;
                        invocationBuilder = invocationBuilder.header(entry.getKey(), (Object)value);
                    }
                    for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
                        String value;
                        String key = entry.getKey();
                        if (headerParams.containsKey(key) || (value = entry.getValue()) == null) continue;
                        invocationBuilder = invocationBuilder.header(key, (Object)value);
                    }
                    Entity<?> entity = this.serialize(body, formParams, contentType);
                    response = null;
                    localStatusCodeString = null;
                    xRequestId = null;
                    try {
                        if ("GET".equals(method)) {
                            response = invocationBuilder.get();
                        } else if ("POST".equals(method)) {
                            response = invocationBuilder.post(entity);
                        } else if ("PUT".equals(method)) {
                            response = invocationBuilder.put(entity);
                        } else if ("DELETE".equals(method)) {
                            response = invocationBuilder.delete();
                        } else if ("PATCH".equals(method)) {
                            response = invocationBuilder.header("X-HTTP-Method-Override", (Object)"PATCH").post(entity);
                        } else {
                            throw new ApiException(500, "unknown method type " + method);
                        }
                        int localStatusCode = response.getStatusInfo().getStatusCode();
                        localStatusCodeString = String.valueOf(localStatusCode);
                        this.statusCode = localStatusCode;
                        this.responseHeaders = this.buildResponseHeaders(response);
                        if (response.getHeaders().get((Object)"x-request-id") != null && ((List)response.getHeaders().get((Object)"x-request-id")).get(0) != null) {
                            xRequestId = String.valueOf(((List)response.getHeaders().get((Object)"x-request-id")).get(0));
                        }
                        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) break block31;
                        t = null;
                    }
                    catch (Throwable throwable) {
                        Long endTS = System.currentTimeMillis();
                        log.info(" " + path + ", " + method + ", X-Request-Id: " + xRequestId + ", Status: " + localStatusCodeString + ", Latency: " + (endTS - startTS) + "ms");
                        try {
                            response.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    Long endTS = System.currentTimeMillis();
                    log.info(" " + path + ", " + method + ", X-Request-Id: " + xRequestId + ", Status: " + localStatusCodeString + ", Latency: " + (endTS - startTS) + "ms");
                    try {
                        response.close();
                    }
                    catch (Exception runtimeException) {
                        // empty catch block
                    }
                    return t;
                }
                if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) break block32;
                if (returnType != null) break block33;
                T t = null;
                Long endTS = System.currentTimeMillis();
                log.info(" " + path + ", " + method + ", X-Request-Id: " + xRequestId + ", Status: " + localStatusCodeString + ", Latency: " + (endTS - startTS) + "ms");
                try {
                    response.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return t;
            }
            T t = this.deserialize(response, returnType);
            Long endTS = System.currentTimeMillis();
            log.info(" " + path + ", " + method + ", X-Request-Id: " + xRequestId + ", Status: " + localStatusCodeString + ", Latency: " + (endTS - startTS) + "ms");
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return t;
        }
        String message = "error";
        String respBody = null;
        if (response.hasEntity()) {
            try {
                message = respBody = String.valueOf(response.readEntity(String.class));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
    }

    private Client buildHttpClient(boolean debugging) {
        ClientConfig clientConfig = new ClientConfig();
        if (this.maxConnections > 0) {
            clientConfig.property("jersey.config.apache.client.connectionManagerShared", (Object)true);
            clientConfig.property("jersey.config.apache.client.connectionManager", (Object)this.connectionManager);
            clientConfig.property("jersey.config.apache.client.keepAliveStrategy", (Object)new CustomConnectionKeepAliveStrategy(this.keepAliveDuration));
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        }
        clientConfig.register(MultiPartFeature.class);
        clientConfig.register((Object)this.json);
        clientConfig.register(JacksonFeature.class);
        if (debugging) {
            clientConfig.register((Object)new LoggingFeature(Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(51200)));
            clientConfig.property("jersey.config.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
            Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME).setLevel(Level.ALL);
        }
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    private Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), (List<String>)headers);
        }
        return responseHeaders;
    }

    private void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    private void setConnectionManager() {
        if (this.maxConnections > 0) {
            this.connectionManager = new PoolingHttpClientConnectionManager();
            this.connectionManager.setMaxTotal(this.maxConnections);
            this.connectionManager.setDefaultMaxPerRoute(this.maxConnections);
        }
    }

    private static class CustomConnectionKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        private long keepAliveTime;

        public CustomConnectionKeepAliveStrategy(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return this.keepAliveTime;
        }
    }
}

