/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.api;

import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.Configuration;
import com.fortanix.sdkms.v1.Pair;
import com.fortanix.sdkms.v1.model.ApprovableResult;
import com.fortanix.sdkms.v1.model.ApprovalRequest;
import com.fortanix.sdkms.v1.model.ApprovalRequestRequest;
import com.fortanix.sdkms.v1.model.ApproveRequest;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ApprovalRequestsApi {
    private ApiClient apiClient;

    public ApprovalRequestsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApprovalRequestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void approve(String requestId, ApproveRequest body) throws ApiException {
        ApproveRequest localVarPostBody = body;
        if (requestId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestId' when calling approve");
        }
        String localVarPath = "/sys/v1/approval_requests/{request-id}/approve".replaceAll("\\{request-id\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ApprovalRequest createApprovalRequest(ApprovalRequestRequest body) throws ApiException {
        ApprovalRequestRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApprovalRequest");
        }
        String localVarPath = "/sys/v1/approval_requests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<ApprovalRequest> localVarReturnType = new GenericType<ApprovalRequest>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteApprovalRequest(String requestId) throws ApiException {
        Object localVarPostBody = null;
        if (requestId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestId' when calling deleteApprovalRequest");
        }
        String localVarPath = "/sys/v1/approval_requests/{request-id}".replaceAll("\\{request-id\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deny(String requestId) throws ApiException {
        Object localVarPostBody = null;
        if (requestId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestId' when calling deny");
        }
        String localVarPath = "/sys/v1/approval_requests/{request-id}/deny".replaceAll("\\{request-id\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ApprovalRequest getApprovalRequest(String requestId) throws ApiException {
        Object localVarPostBody = null;
        if (requestId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestId' when calling getApprovalRequest");
        }
        String localVarPath = "/sys/v1/approval_requests/{request-id}".replaceAll("\\{request-id\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<ApprovalRequest> localVarReturnType = new GenericType<ApprovalRequest>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ApprovalRequest> getApprovalRequests(String requester, String reviewer, String subject, String status) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sys/v1/approval_requests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "requester", requester));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reviewer", reviewer));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "subject", subject));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<List<ApprovalRequest>> localVarReturnType = new GenericType<List<ApprovalRequest>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ApprovableResult getResult(String requestId) throws ApiException {
        Object localVarPostBody = null;
        if (requestId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestId' when calling getResult");
        }
        String localVarPath = "/sys/v1/approval_requests/{request-id}/result".replaceAll("\\{request-id\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<ApprovableResult> localVarReturnType = new GenericType<ApprovableResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

