/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Identifies an object acted upon by an approval request.")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApprovalSubject {
    @JsonProperty(value="group")
    private String group = null;
    @JsonProperty(value="sobject")
    private String sobject = null;
    @JsonProperty(value="app")
    private String app = null;
    @JsonProperty(value="plugin")
    private String plugin = null;

    public ApprovalSubject group(String group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="The ID of the group being acted upon, if the subject is a group.")
    @JsonProperty(value="group")
    public String getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    public void setGroup(String group) {
        this.group = group;
    }

    public ApprovalSubject sobject(String sobject) {
        this.sobject = sobject;
        return this;
    }

    @ApiModelProperty(value="The ID of the security object being acted upon, if the subject is a security object.")
    @JsonProperty(value="sobject")
    public String getSobject() {
        return this.sobject;
    }

    @JsonProperty(value="sobject")
    public void setSobject(String sobject) {
        this.sobject = sobject;
    }

    public ApprovalSubject app(String app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(value="The ID of the app being acted upon, if the subject is a app.")
    @JsonProperty(value="app")
    public String getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    public void setApp(String app) {
        this.app = app;
    }

    public ApprovalSubject plugin(String plugin) {
        this.plugin = plugin;
        return this;
    }

    @ApiModelProperty(value="The ID of the plugin being acted upon, if the subject is a app.")
    @JsonProperty(value="plugin")
    public String getPlugin() {
        return this.plugin;
    }

    @JsonProperty(value="plugin")
    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalSubject approvalSubject = (ApprovalSubject)o;
        return Objects.equals(this.group, approvalSubject.group) && Objects.equals(this.sobject, approvalSubject.sobject) && Objects.equals(this.app, approvalSubject.app) && Objects.equals(this.plugin, approvalSubject.plugin);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.sobject, this.app, this.plugin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApprovalSubject {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    sobject: ").append(this.toIndentedString(this.sobject)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    plugin: ").append(this.toIndentedString(this.plugin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

