/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthType {
    private String value;
    public static final AuthType FORTANIX = new AuthType("Fortanix");
    public static final AuthType FORTANIXMFA = new AuthType("FortanixMFA");
    public static final AuthType EXTERNAL = new AuthType("External");
    private static final Map<String, AuthType> valueMap = new HashMap<String, AuthType>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private AuthType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthType[] values() {
        valueMapLock.lock();
        try {
            AuthType[] authTypeArray = valueMap.values().toArray(new AuthType[valueMap.values().size()]);
            return authTypeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static AuthType fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                AuthType authType = valueMap.get(val);
                return authType;
            }
            AuthType newValue = new AuthType(val);
            valueMap.put(val, newValue);
            AuthType authType = newValue;
            return authType;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Fortanix", FORTANIX);
        valueMap.put("FortanixMFA", FORTANIXMFA);
        valueMap.put("External", EXTERNAL);
    }
}

