/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.DeriveKeyMechanism;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeriveKeyRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="group_id")
    private String groupId = null;
    @JsonProperty(value="key_size")
    private Integer keySize = null;
    @JsonProperty(value="key_type")
    private ObjectType keyType = null;
    @JsonProperty(value="mechanism")
    private DeriveKeyMechanism mechanism = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="key_ops")
    private List<KeyOperations> keyOps = null;
    @JsonProperty(value="custom_metadata")
    private Map<String, String> customMetadata = null;

    public DeriveKeyRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the derived key. Key names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public DeriveKeyRequest groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="Group ID (not name) of the security group that this security object should belong to. The user or application creating this security object must be a member of this group. If no group is specified, the default group for the user or application will be used. ")
    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public DeriveKeyRequest keySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    @ApiModelProperty(required=true, value="Key size of the derived key in bits (not bytes).")
    @JsonProperty(value="key_size")
    public Integer getKeySize() {
        return this.keySize;
    }

    @JsonProperty(value="key_size")
    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public DeriveKeyRequest keyType(ObjectType keyType) {
        this.keyType = keyType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key_type")
    public ObjectType getKeyType() {
        return this.keyType;
    }

    @JsonProperty(value="key_type")
    public void setKeyType(ObjectType keyType) {
        this.keyType = keyType;
    }

    public DeriveKeyRequest mechanism(DeriveKeyMechanism mechanism) {
        this.mechanism = mechanism;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="mechanism")
    public DeriveKeyMechanism getMechanism() {
        return this.mechanism;
    }

    @JsonProperty(value="mechanism")
    public void setMechanism(DeriveKeyMechanism mechanism) {
        this.mechanism = mechanism;
    }

    public DeriveKeyRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether the derived key should have cryptographic operations enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DeriveKeyRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description for the new key.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DeriveKeyRequest keyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public DeriveKeyRequest addKeyOpsItem(KeyOperations keyOpsItem) {
        if (this.keyOps == null) {
            this.keyOps = new ArrayList<KeyOperations>();
        }
        this.keyOps.add(keyOpsItem);
        return this;
    }

    @ApiModelProperty(value="Optional array of key operations to be enabled for this security object. If this property is not provided, the DSM server will provide a default set of key operations. Note that if you provide an empty array, all key operations will be disabled. ")
    @JsonProperty(value="key_ops")
    public List<KeyOperations> getKeyOps() {
        return this.keyOps;
    }

    @JsonProperty(value="key_ops")
    public void setKeyOps(List<KeyOperations> keyOps) {
        this.keyOps = keyOps;
    }

    public DeriveKeyRequest customMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public DeriveKeyRequest putCustomMetadataItem(String key, String customMetadataItem) {
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, customMetadataItem);
        return this;
    }

    @ApiModelProperty(value="User-defined metadata for this key. Stored as key-value pairs.")
    @JsonProperty(value="custom_metadata")
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeriveKeyRequest deriveKeyRequest = (DeriveKeyRequest)o;
        return Objects.equals(this.name, deriveKeyRequest.name) && Objects.equals(this.groupId, deriveKeyRequest.groupId) && Objects.equals(this.keySize, deriveKeyRequest.keySize) && Objects.equals(this.keyType, deriveKeyRequest.keyType) && Objects.equals(this.mechanism, deriveKeyRequest.mechanism) && Objects.equals(this.enabled, deriveKeyRequest.enabled) && Objects.equals(this.description, deriveKeyRequest.description) && Objects.equals(this.keyOps, deriveKeyRequest.keyOps) && Objects.equals(this.customMetadata, deriveKeyRequest.customMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.groupId, this.keySize, this.keyType, this.mechanism, this.enabled, this.description, this.keyOps, this.customMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeriveKeyRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    keySize: ").append(this.toIndentedString(this.keySize)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString(this.keyType)).append("\n");
        sb.append("    mechanism: ").append(this.toIndentedString(this.mechanism)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keyOps: ").append(this.toIndentedString(this.keyOps)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

