/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.FpeConstraints;
import com.fortanix.sdkms.v1.model.FpeDataPart;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Structure of a compound portion of a complex tokenization data type, itself composed of smaller parts. Note that there are three variants here:  - Or -- representing an OR of multiple structures  - Concat -- representing a concatenation of multiple structures  - Multiple -- representing a part possibly repeated multiple times, where the part to be repeated is under the `multiple` field  These three variants correspond to the `or`, `concat`, and `multiple` fields, respectively; one of these fields must be specified. It is an error to try to specify more than one variant (e.g., having both an `or` and a `concat` field).  ***Implementation note: for Or variants, the parser will go in the order of the choices (see description of the `or` field below), and for Multiple variants, the parser will try to (locally) match as many repetitions as possible. (See the description of `FpeDataPart` for more information about why this matters.)*** ")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FpeCompoundPart
extends FpeDataPart {
    @JsonProperty(value="or")
    private List<FpeDataPart> or = null;
    @JsonProperty(value="concat")
    private List<FpeDataPart> concat = null;
    @JsonProperty(value="multiple")
    private FpeDataPart multiple = null;
    @JsonProperty(value="min_repetitions")
    private Integer minRepetitions = null;
    @JsonProperty(value="max_repetitions")
    private Integer maxRepetitions = null;
    @JsonProperty(value="constraints")
    private FpeConstraints constraints = null;
    @JsonProperty(value="preserve")
    private Boolean preserve = null;
    @JsonProperty(value="mask")
    private Boolean mask = null;
    @JsonProperty(value="min_length")
    private Integer minLength = null;
    @JsonProperty(value="max_length")
    private Integer maxLength = null;

    public FpeCompoundPart or(List<FpeDataPart> or) {
        this.or = or;
        return this;
    }

    public FpeCompoundPart addOrItem(FpeDataPart orItem) {
        if (this.or == null) {
            this.or = new ArrayList<FpeDataPart>();
        }
        this.or.add(orItem);
        return this;
    }

    @ApiModelProperty(value="Represents an OR of multiple structures. This cannot be specified alongside the `concat` or `multiple` fields.  ***Implementation note: the order of the choices matters, as the parser will pick the first structure that matches. (The parser is locally \"greedy\"; see the description of `FpeDataPart` for more information about why this matters.)*** ")
    @JsonProperty(value="or")
    public List<FpeDataPart> getOr() {
        return this.or;
    }

    @JsonProperty(value="or")
    public void setOr(List<FpeDataPart> or) {
        this.or = or;
    }

    public FpeCompoundPart concat(List<FpeDataPart> concat) {
        this.concat = concat;
        return this;
    }

    public FpeCompoundPart addConcatItem(FpeDataPart concatItem) {
        if (this.concat == null) {
            this.concat = new ArrayList<FpeDataPart>();
        }
        this.concat.add(concatItem);
        return this;
    }

    @ApiModelProperty(value="Represents a concatentation of multiple structures (in a particular order). This cannot be specified alongside the `or` or `multiple` fields. ")
    @JsonProperty(value="concat")
    public List<FpeDataPart> getConcat() {
        return this.concat;
    }

    @JsonProperty(value="concat")
    public void setConcat(List<FpeDataPart> concat) {
        this.concat = concat;
    }

    public FpeCompoundPart multiple(FpeDataPart multiple) {
        this.multiple = multiple;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="multiple")
    public FpeDataPart getMultiple() {
        return this.multiple;
    }

    @JsonProperty(value="multiple")
    public void setMultiple(FpeDataPart multiple) {
        this.multiple = multiple;
    }

    public FpeCompoundPart minRepetitions(Integer minRepetitions) {
        this.minRepetitions = minRepetitions;
        return this;
    }

    @ApiModelProperty(value="The minimum number of times the subpart can be repeated. This field should only be used if the `multiple` field is being used.")
    @JsonProperty(value="min_repetitions")
    public Integer getMinRepetitions() {
        return this.minRepetitions;
    }

    @JsonProperty(value="min_repetitions")
    public void setMinRepetitions(Integer minRepetitions) {
        this.minRepetitions = minRepetitions;
    }

    public FpeCompoundPart maxRepetitions(Integer maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
        return this;
    }

    @ApiModelProperty(value="The maximum number of times the subpart can be repeated. This field should only be used if the `multiple` field is being used.")
    @JsonProperty(value="max_repetitions")
    public Integer getMaxRepetitions() {
        return this.maxRepetitions;
    }

    @JsonProperty(value="max_repetitions")
    public void setMaxRepetitions(Integer maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public FpeCompoundPart constraints(FpeConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="constraints")
    public FpeConstraints getConstraints() {
        return this.constraints;
    }

    @JsonProperty(value="constraints")
    public void setConstraints(FpeConstraints constraints) {
        this.constraints = constraints;
    }

    public FpeCompoundPart preserve(Boolean preserve) {
        this.preserve = preserve;
        return this;
    }

    @ApiModelProperty(value="Whether the entire part should be preserved as-is (i.e., not tokenized). If this is set, any descendant subparts cannot contain any preserve-related fields set. ")
    @JsonProperty(value="preserve")
    public Boolean getPreserve() {
        return this.preserve;
    }

    @JsonProperty(value="preserve")
    public void setPreserve(Boolean preserve) {
        this.preserve = preserve;
    }

    public FpeCompoundPart mask(Boolean mask) {
        this.mask = mask;
        return this;
    }

    @ApiModelProperty(value="Whether the entire part should be masked when doing masked decryption. If this is set, any descendant subparts cannot contain any mask-related fields set. ")
    @JsonProperty(value="mask")
    public Boolean getMask() {
        return this.mask;
    }

    @JsonProperty(value="mask")
    public void setMask(Boolean mask) {
        this.mask = mask;
    }

    public FpeCompoundPart minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @ApiModelProperty(value="The minimum allowed length for this part (in chars).")
    @JsonProperty(value="min_length")
    public Integer getMinLength() {
        return this.minLength;
    }

    @JsonProperty(value="min_length")
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public FpeCompoundPart maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @ApiModelProperty(value="The minimum allowed length for this part (in chars).")
    @JsonProperty(value="max_length")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @JsonProperty(value="max_length")
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FpeCompoundPart fpeCompoundPart = (FpeCompoundPart)o;
            return Objects.equals(this.or, fpeCompoundPart.or) && Objects.equals(this.concat, fpeCompoundPart.concat) && Objects.equals(this.multiple, fpeCompoundPart.multiple) && Objects.equals(this.minRepetitions, fpeCompoundPart.minRepetitions) && Objects.equals(this.maxRepetitions, fpeCompoundPart.maxRepetitions) && Objects.equals(this.constraints, fpeCompoundPart.constraints) && Objects.equals(this.preserve, fpeCompoundPart.preserve) && Objects.equals(this.mask, fpeCompoundPart.mask) && Objects.equals(this.minLength, fpeCompoundPart.minLength) && Objects.equals(this.maxLength, fpeCompoundPart.maxLength);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.or, this.concat, this.multiple, this.minRepetitions, this.maxRepetitions, this.constraints, this.preserve, this.mask, this.minLength, this.maxLength);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FpeCompoundPart {\n");
        sb.append("    or: ").append(this.toIndentedString(this.or)).append("\n");
        sb.append("    concat: ").append(this.toIndentedString(this.concat)).append("\n");
        sb.append("    multiple: ").append(this.toIndentedString(this.multiple)).append("\n");
        sb.append("    minRepetitions: ").append(this.toIndentedString(this.minRepetitions)).append("\n");
        sb.append("    maxRepetitions: ").append(this.toIndentedString(this.maxRepetitions)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    preserve: ").append(this.toIndentedString(this.preserve)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}

