/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.FpeDateWithBounds;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A structure for indicating that a token part represents a date. The part should be a concatenation that matches one of the three variants below:  - DayMonthYear date -- contains a Day part and a Month part; this corresponds with the `dmy_date` field  - MonthYear date -- contains a Month part and a Year part; this corresponds with the `month_day_date` field  - MonthDay date -- contains a Day part, a Month part, and a Year part; this corresponds with the `month_year_date` field  (with this constraint applying to those subparts). Notice how each variant above corresponds with a particular field; using the wrong field, or multiple fields, is an error. The individual Month, Day, and/or Year parts that comprise the date cannot appear under Or or the Multiple compound part descendants of the overall Date part (i.e., when applying the date constraint, the \"paths\" from the Date part to the Month, Day, and/or Year parts can only \"go through\" concatenations, and not \"through\" Or or Multiple parts). Those parts also have additional restrictions on how they may be preserved; the exact rules are as such:  - A DayMonthYear date may preserve its Year part, and may preserve both its Month and Day parts at the same time. (The Day    part cannot be preserved if the Month part is not, and vice versa.)  - A MonthDay date cannot preserve only its Month part or only its Day part.  - A MonthYear date may preserve its Year part, but cannot preserve its Month part by itself.   It is an error to \"share\" Day, Month, or Year parts across multiple dates. ")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FpeDate {
    @JsonProperty(value="dmy_date")
    private FpeDateWithBounds dmyDate = null;
    @JsonProperty(value="month_day_date")
    private FpeDateWithBounds monthDayDate = null;
    @JsonProperty(value="month_year_date")
    private FpeDateWithBounds monthYearDate = null;

    public FpeDate dmyDate(FpeDateWithBounds dmyDate) {
        this.dmyDate = dmyDate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dmy_date")
    public FpeDateWithBounds getDmyDate() {
        return this.dmyDate;
    }

    @JsonProperty(value="dmy_date")
    public void setDmyDate(FpeDateWithBounds dmyDate) {
        this.dmyDate = dmyDate;
    }

    public FpeDate monthDayDate(FpeDateWithBounds monthDayDate) {
        this.monthDayDate = monthDayDate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="month_day_date")
    public FpeDateWithBounds getMonthDayDate() {
        return this.monthDayDate;
    }

    @JsonProperty(value="month_day_date")
    public void setMonthDayDate(FpeDateWithBounds monthDayDate) {
        this.monthDayDate = monthDayDate;
    }

    public FpeDate monthYearDate(FpeDateWithBounds monthYearDate) {
        this.monthYearDate = monthYearDate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="month_year_date")
    public FpeDateWithBounds getMonthYearDate() {
        return this.monthYearDate;
    }

    @JsonProperty(value="month_year_date")
    public void setMonthYearDate(FpeDateWithBounds monthYearDate) {
        this.monthYearDate = monthYearDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FpeDate fpeDate = (FpeDate)o;
        return Objects.equals(this.dmyDate, fpeDate.dmyDate) && Objects.equals(this.monthDayDate, fpeDate.monthDayDate) && Objects.equals(this.monthYearDate, fpeDate.monthYearDate);
    }

    public int hashCode() {
        return Objects.hash(this.dmyDate, this.monthDayDate, this.monthYearDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FpeDate {\n");
        sb.append("    dmyDate: ").append(this.toIndentedString(this.dmyDate)).append("\n");
        sb.append("    monthDayDate: ").append(this.toIndentedString(this.monthDayDate)).append("\n");
        sb.append("    monthYearDate: ").append(this.toIndentedString(this.monthYearDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

